package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface NetworkSpecFluent<A extends NetworkSpecFluent<A>> extends Fluent<A>{


    public A addToAdditionalNetworks(int index,AdditionalNetworkDefinition item);
    public A setToAdditionalNetworks(int index,AdditionalNetworkDefinition item);
    public A addToAdditionalNetworks(AdditionalNetworkDefinition... items);
    public A addAllToAdditionalNetworks(Collection<AdditionalNetworkDefinition> items);
    public A removeFromAdditionalNetworks(AdditionalNetworkDefinition... items);
    public A removeAllFromAdditionalNetworks(Collection<AdditionalNetworkDefinition> items);
    public A removeMatchingFromAdditionalNetworks(io.fabric8.kubernetes.api.builder.Predicate<AdditionalNetworkDefinitionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAdditionalNetworks instead.
 * @return The buildable object.
 */
@Deprecated public List<AdditionalNetworkDefinition> getAdditionalNetworks();
    public List<AdditionalNetworkDefinition> buildAdditionalNetworks();
    public AdditionalNetworkDefinition buildAdditionalNetwork(int index);
    public AdditionalNetworkDefinition buildFirstAdditionalNetwork();
    public AdditionalNetworkDefinition buildLastAdditionalNetwork();
    public AdditionalNetworkDefinition buildMatchingAdditionalNetwork(io.fabric8.kubernetes.api.builder.Predicate<AdditionalNetworkDefinitionBuilder> predicate);
    public Boolean hasMatchingAdditionalNetwork(io.fabric8.kubernetes.api.builder.Predicate<AdditionalNetworkDefinitionBuilder> predicate);
    public A withAdditionalNetworks(List<AdditionalNetworkDefinition> additionalNetworks);
    public A withAdditionalNetworks(AdditionalNetworkDefinition... additionalNetworks);
    public Boolean hasAdditionalNetworks();
    public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetwork();
    public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetworkLike(AdditionalNetworkDefinition item);
    public NetworkSpecFluent.AdditionalNetworksNested<A> setNewAdditionalNetworkLike(int index,AdditionalNetworkDefinition item);
    public NetworkSpecFluent.AdditionalNetworksNested<A> editAdditionalNetwork(int index);
    public NetworkSpecFluent.AdditionalNetworksNested<A> editFirstAdditionalNetwork();
    public NetworkSpecFluent.AdditionalNetworksNested<A> editLastAdditionalNetwork();
    public NetworkSpecFluent.AdditionalNetworksNested<A> editMatchingAdditionalNetwork(io.fabric8.kubernetes.api.builder.Predicate<AdditionalNetworkDefinitionBuilder> predicate);
    public A addToClusterNetwork(int index,ClusterNetworkEntry item);
    public A setToClusterNetwork(int index,ClusterNetworkEntry item);
    public A addToClusterNetwork(ClusterNetworkEntry... items);
    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items);
    public A removeFromClusterNetwork(ClusterNetworkEntry... items);
    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items);
    public A removeMatchingFromClusterNetwork(io.fabric8.kubernetes.api.builder.Predicate<ClusterNetworkEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildClusterNetwork instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterNetworkEntry> getClusterNetwork();
    public List<ClusterNetworkEntry> buildClusterNetwork();
    public ClusterNetworkEntry buildClusterNetwork(int index);
    public ClusterNetworkEntry buildFirstClusterNetwork();
    public ClusterNetworkEntry buildLastClusterNetwork();
    public ClusterNetworkEntry buildMatchingClusterNetwork(io.fabric8.kubernetes.api.builder.Predicate<ClusterNetworkEntryBuilder> predicate);
    public Boolean hasMatchingClusterNetwork(io.fabric8.kubernetes.api.builder.Predicate<ClusterNetworkEntryBuilder> predicate);
    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork);
    public A withClusterNetwork(ClusterNetworkEntry... clusterNetwork);
    public Boolean hasClusterNetwork();
    public A addNewClusterNetwork(String cidr,Integer hostPrefix);
    public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork();
    public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item);
    public NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item);
    public NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(int index);
    public NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork();
    public NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork();
    public NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(io.fabric8.kubernetes.api.builder.Predicate<ClusterNetworkEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDefaultNetwork instead.
 * @return The buildable object.
 */
@Deprecated public DefaultNetworkDefinition getDefaultNetwork();
    public DefaultNetworkDefinition buildDefaultNetwork();
    public A withDefaultNetwork(DefaultNetworkDefinition defaultNetwork);
    public Boolean hasDefaultNetwork();
    public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetwork();
    public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetworkLike(DefaultNetworkDefinition item);
    public NetworkSpecFluent.DefaultNetworkNested<A> editDefaultNetwork();
    public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetwork();
    public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetworkLike(DefaultNetworkDefinition item);
    public Boolean isDeployKubeProxy();
    public A withDeployKubeProxy(Boolean deployKubeProxy);
    public Boolean hasDeployKubeProxy();
    public A withNewDeployKubeProxy(String arg1);
    public A withNewDeployKubeProxy(boolean arg1);
    public Boolean isDisableMultiNetwork();
    public A withDisableMultiNetwork(Boolean disableMultiNetwork);
    public Boolean hasDisableMultiNetwork();
    public A withNewDisableMultiNetwork(String arg1);
    public A withNewDisableMultiNetwork(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildKubeProxyConfig instead.
 * @return The buildable object.
 */
@Deprecated public ProxyConfig getKubeProxyConfig();
    public ProxyConfig buildKubeProxyConfig();
    public A withKubeProxyConfig(ProxyConfig kubeProxyConfig);
    public Boolean hasKubeProxyConfig();
    public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfig();
    public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfigLike(ProxyConfig item);
    public NetworkSpecFluent.KubeProxyConfigNested<A> editKubeProxyConfig();
    public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfig();
    public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(ProxyConfig item);
    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(String arg1);
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public A addToServiceNetwork(int index,String item);
    public A setToServiceNetwork(int index,String item);
    public A addToServiceNetwork(String... items);
    public A addAllToServiceNetwork(Collection<String> items);
    public A removeFromServiceNetwork(String... items);
    public A removeAllFromServiceNetwork(Collection<String> items);
    public List<String> getServiceNetwork();
    public String getServiceNetwork(int index);
    public String getFirstServiceNetwork();
    public String getLastServiceNetwork();
    public String getMatchingServiceNetwork(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingServiceNetwork(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withServiceNetwork(List<String> serviceNetwork);
    public A withServiceNetwork(String... serviceNetwork);
    public Boolean hasServiceNetwork();
    public A addNewServiceNetwork(String arg1);
    public A addNewServiceNetwork(StringBuilder arg1);
    public A addNewServiceNetwork(StringBuffer arg1);

    public interface AdditionalNetworksNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AdditionalNetworkDefinitionFluent<NetworkSpecFluent.AdditionalNetworksNested<N>>{

        
    public N and();    public N endAdditionalNetwork();
}
    public interface ClusterNetworkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterNetworkEntryFluent<NetworkSpecFluent.ClusterNetworkNested<N>>{

        
    public N and();    public N endClusterNetwork();
}
    public interface DefaultNetworkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DefaultNetworkDefinitionFluent<NetworkSpecFluent.DefaultNetworkNested<N>>{

        
    public N and();    public N endDefaultNetwork();
}
    public interface KubeProxyConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyConfigFluent<NetworkSpecFluent.KubeProxyConfigNested<N>>{

        
    public N and();    public N endKubeProxyConfig();
}


}
