package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface KubeStorageVersionMigratorFluent<A extends KubeStorageVersionMigratorFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KubeStorageVersionMigratorFluent.MetadataNested<A> withNewMetadata();
    public KubeStorageVersionMigratorFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KubeStorageVersionMigratorFluent.MetadataNested<A> editMetadata();
    public KubeStorageVersionMigratorFluent.MetadataNested<A> editOrNewMetadata();
    public KubeStorageVersionMigratorFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KubeStorageVersionMigratorSpec getSpec();
    public KubeStorageVersionMigratorSpec buildSpec();
    public A withSpec(KubeStorageVersionMigratorSpec spec);
    public Boolean hasSpec();
    public KubeStorageVersionMigratorFluent.SpecNested<A> withNewSpec();
    public KubeStorageVersionMigratorFluent.SpecNested<A> withNewSpecLike(KubeStorageVersionMigratorSpec item);
    public KubeStorageVersionMigratorFluent.SpecNested<A> editSpec();
    public KubeStorageVersionMigratorFluent.SpecNested<A> editOrNewSpec();
    public KubeStorageVersionMigratorFluent.SpecNested<A> editOrNewSpecLike(KubeStorageVersionMigratorSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KubeStorageVersionMigratorStatus getStatus();
    public KubeStorageVersionMigratorStatus buildStatus();
    public A withStatus(KubeStorageVersionMigratorStatus status);
    public Boolean hasStatus();
    public KubeStorageVersionMigratorFluent.StatusNested<A> withNewStatus();
    public KubeStorageVersionMigratorFluent.StatusNested<A> withNewStatusLike(KubeStorageVersionMigratorStatus item);
    public KubeStorageVersionMigratorFluent.StatusNested<A> editStatus();
    public KubeStorageVersionMigratorFluent.StatusNested<A> editOrNewStatus();
    public KubeStorageVersionMigratorFluent.StatusNested<A> editOrNewStatusLike(KubeStorageVersionMigratorStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KubeStorageVersionMigratorFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorSpecFluent<KubeStorageVersionMigratorFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorStatusFluent<KubeStorageVersionMigratorFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
