package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeAPIServerBuilder extends KubeAPIServerFluentImpl<KubeAPIServerBuilder> implements VisitableBuilder<KubeAPIServer,KubeAPIServerBuilder>{

    KubeAPIServerFluent<?> fluent;
    Boolean validationEnabled;

    public KubeAPIServerBuilder(){
            this(true);
    }
    public KubeAPIServerBuilder(Boolean validationEnabled){
            this(new KubeAPIServer(), validationEnabled);
    }
    public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent){
            this(fluent, true);
    }
    public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubeAPIServer(), validationEnabled);
    }
    public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent,KubeAPIServer instance){
            this(fluent, instance, true);
    }
    public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent,KubeAPIServer instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubeAPIServerBuilder(KubeAPIServer instance){
            this(instance,true);
    }
    public KubeAPIServerBuilder(KubeAPIServer instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubeAPIServer build(){
            KubeAPIServer buildable = new KubeAPIServer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubeAPIServerBuilder that = (KubeAPIServerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
