package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerHTTPHeadersFluentImpl<A extends IngressControllerHTTPHeadersFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressControllerHTTPHeadersFluent<A>{

    private String forwardedHeaderPolicy;
    private IngressControllerHTTPUniqueIdHeaderPolicyBuilder uniqueId;

    public IngressControllerHTTPHeadersFluentImpl(){
    }
    public IngressControllerHTTPHeadersFluentImpl(IngressControllerHTTPHeaders instance){
            this.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy()); 
            this.withUniqueId(instance.getUniqueId()); 
    }

    public String getForwardedHeaderPolicy(){
            return this.forwardedHeaderPolicy;
    }

    public A withForwardedHeaderPolicy(String forwardedHeaderPolicy){
            this.forwardedHeaderPolicy=forwardedHeaderPolicy; return (A) this;
    }

    public Boolean hasForwardedHeaderPolicy(){
            return this.forwardedHeaderPolicy != null;
    }

    public A withNewForwardedHeaderPolicy(String arg1){
            return (A)withForwardedHeaderPolicy(new String(arg1));
    }

    public A withNewForwardedHeaderPolicy(StringBuilder arg1){
            return (A)withForwardedHeaderPolicy(new String(arg1));
    }

    public A withNewForwardedHeaderPolicy(StringBuffer arg1){
            return (A)withForwardedHeaderPolicy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildUniqueId instead.
 * @return The buildable object.
 */
@Deprecated public IngressControllerHTTPUniqueIdHeaderPolicy getUniqueId(){
            return this.uniqueId!=null?this.uniqueId.build():null;
    }

    public IngressControllerHTTPUniqueIdHeaderPolicy buildUniqueId(){
            return this.uniqueId!=null?this.uniqueId.build():null;
    }

    public A withUniqueId(IngressControllerHTTPUniqueIdHeaderPolicy uniqueId){
            _visitables.get("uniqueId").remove(this.uniqueId);
            if (uniqueId!=null){ this.uniqueId= new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(uniqueId); _visitables.get("uniqueId").add(this.uniqueId);} return (A) this;
    }

    public Boolean hasUniqueId(){
            return this.uniqueId != null;
    }

    public A withNewUniqueId(String format,String name){
            return (A)withUniqueId(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
    }

    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueId(){
            return new UniqueIdNestedImpl();
    }

    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item){
            return new UniqueIdNestedImpl(item);
    }

    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editUniqueId(){
            return withNewUniqueIdLike(getUniqueId());
    }

    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueId(){
            return withNewUniqueIdLike(getUniqueId() != null ? getUniqueId(): new IngressControllerHTTPUniqueIdHeaderPolicyBuilder().build());
    }

    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item){
            return withNewUniqueIdLike(getUniqueId() != null ? getUniqueId(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            IngressControllerHTTPHeadersFluentImpl that = (IngressControllerHTTPHeadersFluentImpl) o;
            if (forwardedHeaderPolicy != null ? !forwardedHeaderPolicy.equals(that.forwardedHeaderPolicy) :that.forwardedHeaderPolicy != null) return false;
            if (uniqueId != null ? !uniqueId.equals(that.uniqueId) :that.uniqueId != null) return false;
            return true;
    }


    public class UniqueIdNestedImpl<N> extends IngressControllerHTTPUniqueIdHeaderPolicyFluentImpl<IngressControllerHTTPHeadersFluent.UniqueIdNested<N>> implements IngressControllerHTTPHeadersFluent.UniqueIdNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;
    
            UniqueIdNestedImpl(IngressControllerHTTPUniqueIdHeaderPolicy item){
                    this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
            }
            UniqueIdNestedImpl(){
                    this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this);
            }
    
    public N and(){
            return (N) IngressControllerHTTPHeadersFluentImpl.this.withUniqueId(builder.build());
    }
    public N endUniqueId(){
            return and();
    }

}


}
