package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerCaptureHTTPHeaderBuilder extends IngressControllerCaptureHTTPHeaderFluentImpl<IngressControllerCaptureHTTPHeaderBuilder> implements VisitableBuilder<IngressControllerCaptureHTTPHeader,IngressControllerCaptureHTTPHeaderBuilder>{

    IngressControllerCaptureHTTPHeaderFluent<?> fluent;
    Boolean validationEnabled;

    public IngressControllerCaptureHTTPHeaderBuilder(){
            this(true);
    }
    public IngressControllerCaptureHTTPHeaderBuilder(Boolean validationEnabled){
            this(new IngressControllerCaptureHTTPHeader(), validationEnabled);
    }
    public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeaderFluent<?> fluent){
            this(fluent, true);
    }
    public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeaderFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IngressControllerCaptureHTTPHeader(), validationEnabled);
    }
    public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeaderFluent<?> fluent,IngressControllerCaptureHTTPHeader instance){
            this(fluent, instance, true);
    }
    public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeaderFluent<?> fluent,IngressControllerCaptureHTTPHeader instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxLength(instance.getMaxLength()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeader instance){
            this(instance,true);
    }
    public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeader instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxLength(instance.getMaxLength()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public IngressControllerCaptureHTTPHeader build(){
            IngressControllerCaptureHTTPHeader buildable = new IngressControllerCaptureHTTPHeader(fluent.getMaxLength(),fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressControllerCaptureHTTPHeaderBuilder that = (IngressControllerCaptureHTTPHeaderBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
