package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;

public class DefaultNetworkDefinitionFluentImpl<A extends DefaultNetworkDefinitionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DefaultNetworkDefinitionFluent<A>{

    private KuryrConfigBuilder kuryrConfig;
    private OpenShiftSDNConfigBuilder openshiftSDNConfig;
    private OVNKubernetesConfigBuilder ovnKubernetesConfig;
    private String type;

    public DefaultNetworkDefinitionFluentImpl(){
    }
    public DefaultNetworkDefinitionFluentImpl(DefaultNetworkDefinition instance){
            this.withKuryrConfig(instance.getKuryrConfig()); 
            this.withOpenshiftSDNConfig(instance.getOpenshiftSDNConfig()); 
            this.withOvnKubernetesConfig(instance.getOvnKubernetesConfig()); 
            this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildKuryrConfig instead.
 * @return The buildable object.
 */
@Deprecated public KuryrConfig getKuryrConfig(){
            return this.kuryrConfig!=null?this.kuryrConfig.build():null;
    }

    public KuryrConfig buildKuryrConfig(){
            return this.kuryrConfig!=null?this.kuryrConfig.build():null;
    }

    public A withKuryrConfig(KuryrConfig kuryrConfig){
            _visitables.get("kuryrConfig").remove(this.kuryrConfig);
            if (kuryrConfig!=null){ this.kuryrConfig= new KuryrConfigBuilder(kuryrConfig); _visitables.get("kuryrConfig").add(this.kuryrConfig);} return (A) this;
    }

    public Boolean hasKuryrConfig(){
            return this.kuryrConfig != null;
    }

    public DefaultNetworkDefinitionFluent.KuryrConfigNested<A> withNewKuryrConfig(){
            return new KuryrConfigNestedImpl();
    }

    public DefaultNetworkDefinitionFluent.KuryrConfigNested<A> withNewKuryrConfigLike(KuryrConfig item){
            return new KuryrConfigNestedImpl(item);
    }

    public DefaultNetworkDefinitionFluent.KuryrConfigNested<A> editKuryrConfig(){
            return withNewKuryrConfigLike(getKuryrConfig());
    }

    public DefaultNetworkDefinitionFluent.KuryrConfigNested<A> editOrNewKuryrConfig(){
            return withNewKuryrConfigLike(getKuryrConfig() != null ? getKuryrConfig(): new KuryrConfigBuilder().build());
    }

    public DefaultNetworkDefinitionFluent.KuryrConfigNested<A> editOrNewKuryrConfigLike(KuryrConfig item){
            return withNewKuryrConfigLike(getKuryrConfig() != null ? getKuryrConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOpenshiftSDNConfig instead.
 * @return The buildable object.
 */
@Deprecated public OpenShiftSDNConfig getOpenshiftSDNConfig(){
            return this.openshiftSDNConfig!=null?this.openshiftSDNConfig.build():null;
    }

    public OpenShiftSDNConfig buildOpenshiftSDNConfig(){
            return this.openshiftSDNConfig!=null?this.openshiftSDNConfig.build():null;
    }

    public A withOpenshiftSDNConfig(OpenShiftSDNConfig openshiftSDNConfig){
            _visitables.get("openshiftSDNConfig").remove(this.openshiftSDNConfig);
            if (openshiftSDNConfig!=null){ this.openshiftSDNConfig= new OpenShiftSDNConfigBuilder(openshiftSDNConfig); _visitables.get("openshiftSDNConfig").add(this.openshiftSDNConfig);} return (A) this;
    }

    public Boolean hasOpenshiftSDNConfig(){
            return this.openshiftSDNConfig != null;
    }

    public A withNewOpenshiftSDNConfig(Boolean enableUnidling,String mode,Integer mtu,Boolean useExternalOpenvswitch,Integer vxlanPort){
            return (A)withOpenshiftSDNConfig(new OpenShiftSDNConfig(enableUnidling, mode, mtu, useExternalOpenvswitch, vxlanPort));
    }

    public DefaultNetworkDefinitionFluent.OpenshiftSDNConfigNested<A> withNewOpenshiftSDNConfig(){
            return new OpenshiftSDNConfigNestedImpl();
    }

    public DefaultNetworkDefinitionFluent.OpenshiftSDNConfigNested<A> withNewOpenshiftSDNConfigLike(OpenShiftSDNConfig item){
            return new OpenshiftSDNConfigNestedImpl(item);
    }

    public DefaultNetworkDefinitionFluent.OpenshiftSDNConfigNested<A> editOpenshiftSDNConfig(){
            return withNewOpenshiftSDNConfigLike(getOpenshiftSDNConfig());
    }

    public DefaultNetworkDefinitionFluent.OpenshiftSDNConfigNested<A> editOrNewOpenshiftSDNConfig(){
            return withNewOpenshiftSDNConfigLike(getOpenshiftSDNConfig() != null ? getOpenshiftSDNConfig(): new OpenShiftSDNConfigBuilder().build());
    }

    public DefaultNetworkDefinitionFluent.OpenshiftSDNConfigNested<A> editOrNewOpenshiftSDNConfigLike(OpenShiftSDNConfig item){
            return withNewOpenshiftSDNConfigLike(getOpenshiftSDNConfig() != null ? getOpenshiftSDNConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOvnKubernetesConfig instead.
 * @return The buildable object.
 */
@Deprecated public OVNKubernetesConfig getOvnKubernetesConfig(){
            return this.ovnKubernetesConfig!=null?this.ovnKubernetesConfig.build():null;
    }

    public OVNKubernetesConfig buildOvnKubernetesConfig(){
            return this.ovnKubernetesConfig!=null?this.ovnKubernetesConfig.build():null;
    }

    public A withOvnKubernetesConfig(OVNKubernetesConfig ovnKubernetesConfig){
            _visitables.get("ovnKubernetesConfig").remove(this.ovnKubernetesConfig);
            if (ovnKubernetesConfig!=null){ this.ovnKubernetesConfig= new OVNKubernetesConfigBuilder(ovnKubernetesConfig); _visitables.get("ovnKubernetesConfig").add(this.ovnKubernetesConfig);} return (A) this;
    }

    public Boolean hasOvnKubernetesConfig(){
            return this.ovnKubernetesConfig != null;
    }

    public DefaultNetworkDefinitionFluent.OvnKubernetesConfigNested<A> withNewOvnKubernetesConfig(){
            return new OvnKubernetesConfigNestedImpl();
    }

    public DefaultNetworkDefinitionFluent.OvnKubernetesConfigNested<A> withNewOvnKubernetesConfigLike(OVNKubernetesConfig item){
            return new OvnKubernetesConfigNestedImpl(item);
    }

    public DefaultNetworkDefinitionFluent.OvnKubernetesConfigNested<A> editOvnKubernetesConfig(){
            return withNewOvnKubernetesConfigLike(getOvnKubernetesConfig());
    }

    public DefaultNetworkDefinitionFluent.OvnKubernetesConfigNested<A> editOrNewOvnKubernetesConfig(){
            return withNewOvnKubernetesConfigLike(getOvnKubernetesConfig() != null ? getOvnKubernetesConfig(): new OVNKubernetesConfigBuilder().build());
    }

    public DefaultNetworkDefinitionFluent.OvnKubernetesConfigNested<A> editOrNewOvnKubernetesConfigLike(OVNKubernetesConfig item){
            return withNewOvnKubernetesConfigLike(getOvnKubernetesConfig() != null ? getOvnKubernetesConfig(): item);
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DefaultNetworkDefinitionFluentImpl that = (DefaultNetworkDefinitionFluentImpl) o;
            if (kuryrConfig != null ? !kuryrConfig.equals(that.kuryrConfig) :that.kuryrConfig != null) return false;
            if (openshiftSDNConfig != null ? !openshiftSDNConfig.equals(that.openshiftSDNConfig) :that.openshiftSDNConfig != null) return false;
            if (ovnKubernetesConfig != null ? !ovnKubernetesConfig.equals(that.ovnKubernetesConfig) :that.ovnKubernetesConfig != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class KuryrConfigNestedImpl<N> extends KuryrConfigFluentImpl<DefaultNetworkDefinitionFluent.KuryrConfigNested<N>> implements DefaultNetworkDefinitionFluent.KuryrConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KuryrConfigBuilder builder;
    
            KuryrConfigNestedImpl(KuryrConfig item){
                    this.builder = new KuryrConfigBuilder(this, item);
            }
            KuryrConfigNestedImpl(){
                    this.builder = new KuryrConfigBuilder(this);
            }
    
    public N and(){
            return (N) DefaultNetworkDefinitionFluentImpl.this.withKuryrConfig(builder.build());
    }
    public N endKuryrConfig(){
            return and();
    }

}
    public class OpenshiftSDNConfigNestedImpl<N> extends OpenShiftSDNConfigFluentImpl<DefaultNetworkDefinitionFluent.OpenshiftSDNConfigNested<N>> implements DefaultNetworkDefinitionFluent.OpenshiftSDNConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OpenShiftSDNConfigBuilder builder;
    
            OpenshiftSDNConfigNestedImpl(OpenShiftSDNConfig item){
                    this.builder = new OpenShiftSDNConfigBuilder(this, item);
            }
            OpenshiftSDNConfigNestedImpl(){
                    this.builder = new OpenShiftSDNConfigBuilder(this);
            }
    
    public N and(){
            return (N) DefaultNetworkDefinitionFluentImpl.this.withOpenshiftSDNConfig(builder.build());
    }
    public N endOpenshiftSDNConfig(){
            return and();
    }

}
    public class OvnKubernetesConfigNestedImpl<N> extends OVNKubernetesConfigFluentImpl<DefaultNetworkDefinitionFluent.OvnKubernetesConfigNested<N>> implements DefaultNetworkDefinitionFluent.OvnKubernetesConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OVNKubernetesConfigBuilder builder;
    
            OvnKubernetesConfigNestedImpl(OVNKubernetesConfig item){
                    this.builder = new OVNKubernetesConfigBuilder(this, item);
            }
            OvnKubernetesConfigNestedImpl(){
                    this.builder = new OVNKubernetesConfigBuilder(this);
            }
    
    public N and(){
            return (N) DefaultNetworkDefinitionFluentImpl.this.withOvnKubernetesConfig(builder.build());
    }
    public N endOvnKubernetesConfig(){
            return and();
    }

}


}
