package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class DNSStatusFluentImpl<A extends DNSStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DNSStatusFluent<A>{

    private String clusterDomain;
    private String clusterIP;
    private List<OperatorConditionBuilder> conditions =  new ArrayList<OperatorConditionBuilder>();

    public DNSStatusFluentImpl(){
    }
    public DNSStatusFluentImpl(DNSStatus instance){
            this.withClusterDomain(instance.getClusterDomain()); 
            this.withClusterIP(instance.getClusterIP()); 
            this.withConditions(instance.getConditions()); 
    }

    public String getClusterDomain(){
            return this.clusterDomain;
    }

    public A withClusterDomain(String clusterDomain){
            this.clusterDomain=clusterDomain; return (A) this;
    }

    public Boolean hasClusterDomain(){
            return this.clusterDomain != null;
    }

    public A withNewClusterDomain(String arg1){
            return (A)withClusterDomain(new String(arg1));
    }

    public A withNewClusterDomain(StringBuilder arg1){
            return (A)withClusterDomain(new String(arg1));
    }

    public A withNewClusterDomain(StringBuffer arg1){
            return (A)withClusterDomain(new String(arg1));
    }

    public String getClusterIP(){
            return this.clusterIP;
    }

    public A withClusterIP(String clusterIP){
            this.clusterIP=clusterIP; return (A) this;
    }

    public Boolean hasClusterIP(){
            return this.clusterIP != null;
    }

    public A withNewClusterIP(String arg1){
            return (A)withClusterIP(new String(arg1));
    }

    public A withNewClusterIP(StringBuilder arg1){
            return (A)withClusterIP(new String(arg1));
    }

    public A withNewClusterIP(StringBuffer arg1){
            return (A)withClusterIP(new String(arg1));
    }

    public A addToConditions(int index,OperatorCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,OperatorCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(OperatorCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
            for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<OperatorCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
            for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(OperatorCondition... items){
            for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<OperatorCondition> items){
            for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<OperatorConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              OperatorConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions(){
            return build(conditions);
    }

    public List<OperatorCondition> buildConditions(){
            return build(conditions);
    }

    public OperatorCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public OperatorCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public OperatorCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public OperatorCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate){
            for (OperatorConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate){
            for (OperatorConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<OperatorCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<OperatorConditionBuilder>(); for (OperatorCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(OperatorCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (OperatorCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type){
            return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
    }

    public DNSStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public DNSStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public DNSStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public DNSStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public DNSStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public DNSStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public DNSStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DNSStatusFluentImpl that = (DNSStatusFluentImpl) o;
            if (clusterDomain != null ? !clusterDomain.equals(that.clusterDomain) :that.clusterDomain != null) return false;
            if (clusterIP != null ? !clusterIP.equals(that.clusterIP) :that.clusterIP != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends OperatorConditionFluentImpl<DNSStatusFluent.ConditionsNested<N>> implements DNSStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OperatorConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,OperatorCondition item){
                    this.index = index;
                    this.builder = new OperatorConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new OperatorConditionBuilder(this);
            }
    
    public N and(){
            return (N) DNSStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition(){
            return and();
    }

}


}
