package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSSpecBuilder extends DNSSpecFluentImpl<DNSSpecBuilder> implements VisitableBuilder<DNSSpec,DNSSpecBuilder>{

    DNSSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DNSSpecBuilder(){
            this(true);
    }
    public DNSSpecBuilder(Boolean validationEnabled){
            this(new DNSSpec(), validationEnabled);
    }
    public DNSSpecBuilder(DNSSpecFluent<?> fluent){
            this(fluent, true);
    }
    public DNSSpecBuilder(DNSSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DNSSpec(), validationEnabled);
    }
    public DNSSpecBuilder(DNSSpecFluent<?> fluent,DNSSpec instance){
            this(fluent, instance, true);
    }
    public DNSSpecBuilder(DNSSpecFluent<?> fluent,DNSSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withServers(instance.getServers()); 
            this.validationEnabled = validationEnabled; 
    }
    public DNSSpecBuilder(DNSSpec instance){
            this(instance,true);
    }
    public DNSSpecBuilder(DNSSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withServers(instance.getServers()); 
            this.validationEnabled = validationEnabled; 
    }

    public DNSSpec build(){
            DNSSpec buildable = new DNSSpec(fluent.getServers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DNSSpecBuilder that = (DNSSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
