package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class DNSRecordSpecFluentImpl<A extends DNSRecordSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DNSRecordSpecFluent<A>{

    private String dnsName;
    private Long recordTTL;
    private String recordType;
    private List<String> targets = new ArrayList<String>();

    public DNSRecordSpecFluentImpl(){
    }
    public DNSRecordSpecFluentImpl(DNSRecordSpec instance){
            this.withDnsName(instance.getDnsName()); 
            this.withRecordTTL(instance.getRecordTTL()); 
            this.withRecordType(instance.getRecordType()); 
            this.withTargets(instance.getTargets()); 
    }

    public String getDnsName(){
            return this.dnsName;
    }

    public A withDnsName(String dnsName){
            this.dnsName=dnsName; return (A) this;
    }

    public Boolean hasDnsName(){
            return this.dnsName != null;
    }

    public A withNewDnsName(String arg1){
            return (A)withDnsName(new String(arg1));
    }

    public A withNewDnsName(StringBuilder arg1){
            return (A)withDnsName(new String(arg1));
    }

    public A withNewDnsName(StringBuffer arg1){
            return (A)withDnsName(new String(arg1));
    }

    public Long getRecordTTL(){
            return this.recordTTL;
    }

    public A withRecordTTL(Long recordTTL){
            this.recordTTL=recordTTL; return (A) this;
    }

    public Boolean hasRecordTTL(){
            return this.recordTTL != null;
    }

    public String getRecordType(){
            return this.recordType;
    }

    public A withRecordType(String recordType){
            this.recordType=recordType; return (A) this;
    }

    public Boolean hasRecordType(){
            return this.recordType != null;
    }

    public A withNewRecordType(String arg1){
            return (A)withRecordType(new String(arg1));
    }

    public A withNewRecordType(StringBuilder arg1){
            return (A)withRecordType(new String(arg1));
    }

    public A withNewRecordType(StringBuffer arg1){
            return (A)withRecordType(new String(arg1));
    }

    public A addToTargets(int index,String item){
            if (this.targets == null) {this.targets = new ArrayList<String>();}
            this.targets.add(index, item);
            return (A)this;
    }

    public A setToTargets(int index,String item){
            if (this.targets == null) {this.targets = new ArrayList<String>();}
            this.targets.set(index, item); return (A)this;
    }

    public A addToTargets(String... items){
            if (this.targets == null) {this.targets = new ArrayList<String>();}
            for (String item : items) {this.targets.add(item);} return (A)this;
    }

    public A addAllToTargets(Collection<String> items){
            if (this.targets == null) {this.targets = new ArrayList<String>();}
            for (String item : items) {this.targets.add(item);} return (A)this;
    }

    public A removeFromTargets(String... items){
            for (String item : items) {if (this.targets!= null){ this.targets.remove(item);}} return (A)this;
    }

    public A removeAllFromTargets(Collection<String> items){
            for (String item : items) {if (this.targets!= null){ this.targets.remove(item);}} return (A)this;
    }

    public List<String> getTargets(){
            return this.targets;
    }

    public String getTarget(int index){
            return this.targets.get(index);
    }

    public String getFirstTarget(){
            return this.targets.get(0);
    }

    public String getLastTarget(){
            return this.targets.get(targets.size() - 1);
    }

    public String getMatchingTarget(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: targets) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTarget(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: targets) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTargets(List<String> targets){
            if (this.targets != null) { _visitables.get("targets").removeAll(this.targets);}
            if (targets != null) {this.targets = new ArrayList<String>(); for (String item : targets){this.addToTargets(item);}} else { this.targets = null;} return (A) this;
    }

    public A withTargets(String... targets){
            if (this.targets != null) {this.targets.clear();}
            if (targets != null) {for (String item :targets){ this.addToTargets(item);}} return (A) this;
    }

    public Boolean hasTargets(){
            return targets != null && !targets.isEmpty();
    }

    public A addNewTarget(String arg1){
            return (A)addToTargets(new String(arg1));
    }

    public A addNewTarget(StringBuilder arg1){
            return (A)addToTargets(new String(arg1));
    }

    public A addNewTarget(StringBuffer arg1){
            return (A)addToTargets(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DNSRecordSpecFluentImpl that = (DNSRecordSpecFluentImpl) o;
            if (dnsName != null ? !dnsName.equals(that.dnsName) :that.dnsName != null) return false;
            if (recordTTL != null ? !recordTTL.equals(that.recordTTL) :that.recordTTL != null) return false;
            if (recordType != null ? !recordType.equals(that.recordType) :that.recordType != null) return false;
            if (targets != null ? !targets.equals(that.targets) :that.targets != null) return false;
            return true;
    }




}
