package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AWSNetworkLoadBalancerParametersBuilder extends AWSNetworkLoadBalancerParametersFluentImpl<AWSNetworkLoadBalancerParametersBuilder> implements VisitableBuilder<AWSNetworkLoadBalancerParameters,AWSNetworkLoadBalancerParametersBuilder>{

    AWSNetworkLoadBalancerParametersFluent<?> fluent;
    Boolean validationEnabled;

    public AWSNetworkLoadBalancerParametersBuilder(){
            this(true);
    }
    public AWSNetworkLoadBalancerParametersBuilder(Boolean validationEnabled){
            this(new AWSNetworkLoadBalancerParameters(), validationEnabled);
    }
    public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParametersFluent<?> fluent){
            this(fluent, true);
    }
    public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AWSNetworkLoadBalancerParameters(), validationEnabled);
    }
    public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParametersFluent<?> fluent,AWSNetworkLoadBalancerParameters instance){
            this(fluent, instance, true);
    }
    public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParametersFluent<?> fluent,AWSNetworkLoadBalancerParameters instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParameters instance){
            this(instance,true);
    }
    public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParameters instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public AWSNetworkLoadBalancerParameters build(){
            AWSNetworkLoadBalancerParameters buildable = new AWSNetworkLoadBalancerParameters();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AWSNetworkLoadBalancerParametersBuilder that = (AWSNetworkLoadBalancerParametersBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
