package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TimeRangeBuilder extends TimeRangeFluent<TimeRangeBuilder> implements VisitableBuilder<TimeRange,TimeRangeBuilder>{
  public TimeRangeBuilder() {
    this(false);
  }
  public TimeRangeBuilder(Boolean validationEnabled) {
    this(new TimeRange(), validationEnabled);
  }
  public TimeRangeBuilder(TimeRangeFluent<?> fluent) {
    this(fluent, false);
  }
  public TimeRangeBuilder(TimeRangeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TimeRange(), validationEnabled);
  }
  public TimeRangeBuilder(TimeRangeFluent<?> fluent,TimeRange instance) {
    this(fluent, instance, false);
  }
  public TimeRangeBuilder(TimeRangeFluent<?> fluent,TimeRange instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TimeRange());

    if (instance != null) {
      fluent.withEndTime(instance.getEndTime());
      fluent.withStartTime(instance.getStartTime());
      fluent.withEndTime(instance.getEndTime());
      fluent.withStartTime(instance.getStartTime());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TimeRangeBuilder(TimeRange instance) {
    this(instance,false);
  }
  public TimeRangeBuilder(TimeRange instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TimeRange());

    if (instance != null) {
      this.withEndTime(instance.getEndTime());
      this.withStartTime(instance.getStartTime());
      this.withEndTime(instance.getEndTime());
      this.withStartTime(instance.getStartTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TimeRangeFluent<?> fluent;
  Boolean validationEnabled;
  public TimeRange build() {
    TimeRange buildable = new TimeRange(fluent.getEndTime(),fluent.getStartTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}