package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TimeIntervalBuilder extends TimeIntervalFluent<TimeIntervalBuilder> implements VisitableBuilder<TimeInterval,TimeIntervalBuilder>{
  public TimeIntervalBuilder() {
    this(false);
  }
  public TimeIntervalBuilder(Boolean validationEnabled) {
    this(new TimeInterval(), validationEnabled);
  }
  public TimeIntervalBuilder(TimeIntervalFluent<?> fluent) {
    this(fluent, false);
  }
  public TimeIntervalBuilder(TimeIntervalFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TimeInterval(), validationEnabled);
  }
  public TimeIntervalBuilder(TimeIntervalFluent<?> fluent,TimeInterval instance) {
    this(fluent, instance, false);
  }
  public TimeIntervalBuilder(TimeIntervalFluent<?> fluent,TimeInterval instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TimeInterval());

    if (instance != null) {
      fluent.withDaysOfMonth(instance.getDaysOfMonth());
      fluent.withMonths(instance.getMonths());
      fluent.withTimes(instance.getTimes());
      fluent.withWeekdays(instance.getWeekdays());
      fluent.withYears(instance.getYears());
      fluent.withDaysOfMonth(instance.getDaysOfMonth());
      fluent.withMonths(instance.getMonths());
      fluent.withTimes(instance.getTimes());
      fluent.withWeekdays(instance.getWeekdays());
      fluent.withYears(instance.getYears());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TimeIntervalBuilder(TimeInterval instance) {
    this(instance,false);
  }
  public TimeIntervalBuilder(TimeInterval instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TimeInterval());

    if (instance != null) {
      this.withDaysOfMonth(instance.getDaysOfMonth());
      this.withMonths(instance.getMonths());
      this.withTimes(instance.getTimes());
      this.withWeekdays(instance.getWeekdays());
      this.withYears(instance.getYears());
      this.withDaysOfMonth(instance.getDaysOfMonth());
      this.withMonths(instance.getMonths());
      this.withTimes(instance.getTimes());
      this.withWeekdays(instance.getWeekdays());
      this.withYears(instance.getYears());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TimeIntervalFluent<?> fluent;
  Boolean validationEnabled;
  public TimeInterval build() {
    TimeInterval buildable = new TimeInterval(fluent.buildDaysOfMonth(),fluent.getMonths(),fluent.buildTimes(),fluent.getWeekdays(),fluent.getYears());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}