package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SNSConfigBuilder extends SNSConfigFluent<SNSConfigBuilder> implements VisitableBuilder<SNSConfig,SNSConfigBuilder>{
  public SNSConfigBuilder() {
    this(false);
  }
  public SNSConfigBuilder(Boolean validationEnabled) {
    this(new SNSConfig(), validationEnabled);
  }
  public SNSConfigBuilder(SNSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public SNSConfigBuilder(SNSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SNSConfig(), validationEnabled);
  }
  public SNSConfigBuilder(SNSConfigFluent<?> fluent,SNSConfig instance) {
    this(fluent, instance, false);
  }
  public SNSConfigBuilder(SNSConfigFluent<?> fluent,SNSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SNSConfig());

    if (instance != null) {
      fluent.withApiURL(instance.getApiURL());
      fluent.withAttributes(instance.getAttributes());
      fluent.withHttpConfig(instance.getHttpConfig());
      fluent.withMessage(instance.getMessage());
      fluent.withPhoneNumber(instance.getPhoneNumber());
      fluent.withSendResolved(instance.getSendResolved());
      fluent.withSigv4(instance.getSigv4());
      fluent.withSubject(instance.getSubject());
      fluent.withTargetARN(instance.getTargetARN());
      fluent.withTopicARN(instance.getTopicARN());
      fluent.withApiURL(instance.getApiURL());
      fluent.withAttributes(instance.getAttributes());
      fluent.withHttpConfig(instance.getHttpConfig());
      fluent.withMessage(instance.getMessage());
      fluent.withPhoneNumber(instance.getPhoneNumber());
      fluent.withSendResolved(instance.getSendResolved());
      fluent.withSigv4(instance.getSigv4());
      fluent.withSubject(instance.getSubject());
      fluent.withTargetARN(instance.getTargetARN());
      fluent.withTopicARN(instance.getTopicARN());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SNSConfigBuilder(SNSConfig instance) {
    this(instance,false);
  }
  public SNSConfigBuilder(SNSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SNSConfig());

    if (instance != null) {
      this.withApiURL(instance.getApiURL());
      this.withAttributes(instance.getAttributes());
      this.withHttpConfig(instance.getHttpConfig());
      this.withMessage(instance.getMessage());
      this.withPhoneNumber(instance.getPhoneNumber());
      this.withSendResolved(instance.getSendResolved());
      this.withSigv4(instance.getSigv4());
      this.withSubject(instance.getSubject());
      this.withTargetARN(instance.getTargetARN());
      this.withTopicARN(instance.getTopicARN());
      this.withApiURL(instance.getApiURL());
      this.withAttributes(instance.getAttributes());
      this.withHttpConfig(instance.getHttpConfig());
      this.withMessage(instance.getMessage());
      this.withPhoneNumber(instance.getPhoneNumber());
      this.withSendResolved(instance.getSendResolved());
      this.withSigv4(instance.getSigv4());
      this.withSubject(instance.getSubject());
      this.withTargetARN(instance.getTargetARN());
      this.withTopicARN(instance.getTopicARN());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SNSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public SNSConfig build() {
    SNSConfig buildable = new SNSConfig(fluent.getApiURL(),fluent.getAttributes(),fluent.buildHttpConfig(),fluent.getMessage(),fluent.getPhoneNumber(),fluent.getSendResolved(),fluent.buildSigv4(),fluent.getSubject(),fluent.getTargetARN(),fluent.getTopicARN());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}