package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReceiverBuilder extends ReceiverFluent<ReceiverBuilder> implements VisitableBuilder<Receiver,ReceiverBuilder>{
  public ReceiverBuilder() {
    this(false);
  }
  public ReceiverBuilder(Boolean validationEnabled) {
    this(new Receiver(), validationEnabled);
  }
  public ReceiverBuilder(ReceiverFluent<?> fluent) {
    this(fluent, false);
  }
  public ReceiverBuilder(ReceiverFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Receiver(), validationEnabled);
  }
  public ReceiverBuilder(ReceiverFluent<?> fluent,Receiver instance) {
    this(fluent, instance, false);
  }
  public ReceiverBuilder(ReceiverFluent<?> fluent,Receiver instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Receiver());

    if (instance != null) {
      fluent.withEmailConfigs(instance.getEmailConfigs());
      fluent.withName(instance.getName());
      fluent.withOpsgenieConfigs(instance.getOpsgenieConfigs());
      fluent.withPagerdutyConfigs(instance.getPagerdutyConfigs());
      fluent.withPushoverConfigs(instance.getPushoverConfigs());
      fluent.withSlackConfigs(instance.getSlackConfigs());
      fluent.withSnsConfigs(instance.getSnsConfigs());
      fluent.withTelegramConfigs(instance.getTelegramConfigs());
      fluent.withVictoropsConfigs(instance.getVictoropsConfigs());
      fluent.withWebhookConfigs(instance.getWebhookConfigs());
      fluent.withWechatConfigs(instance.getWechatConfigs());
      fluent.withEmailConfigs(instance.getEmailConfigs());
      fluent.withName(instance.getName());
      fluent.withOpsgenieConfigs(instance.getOpsgenieConfigs());
      fluent.withPagerdutyConfigs(instance.getPagerdutyConfigs());
      fluent.withPushoverConfigs(instance.getPushoverConfigs());
      fluent.withSlackConfigs(instance.getSlackConfigs());
      fluent.withSnsConfigs(instance.getSnsConfigs());
      fluent.withTelegramConfigs(instance.getTelegramConfigs());
      fluent.withVictoropsConfigs(instance.getVictoropsConfigs());
      fluent.withWebhookConfigs(instance.getWebhookConfigs());
      fluent.withWechatConfigs(instance.getWechatConfigs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReceiverBuilder(Receiver instance) {
    this(instance,false);
  }
  public ReceiverBuilder(Receiver instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Receiver());

    if (instance != null) {
      this.withEmailConfigs(instance.getEmailConfigs());
      this.withName(instance.getName());
      this.withOpsgenieConfigs(instance.getOpsgenieConfigs());
      this.withPagerdutyConfigs(instance.getPagerdutyConfigs());
      this.withPushoverConfigs(instance.getPushoverConfigs());
      this.withSlackConfigs(instance.getSlackConfigs());
      this.withSnsConfigs(instance.getSnsConfigs());
      this.withTelegramConfigs(instance.getTelegramConfigs());
      this.withVictoropsConfigs(instance.getVictoropsConfigs());
      this.withWebhookConfigs(instance.getWebhookConfigs());
      this.withWechatConfigs(instance.getWechatConfigs());
      this.withEmailConfigs(instance.getEmailConfigs());
      this.withName(instance.getName());
      this.withOpsgenieConfigs(instance.getOpsgenieConfigs());
      this.withPagerdutyConfigs(instance.getPagerdutyConfigs());
      this.withPushoverConfigs(instance.getPushoverConfigs());
      this.withSlackConfigs(instance.getSlackConfigs());
      this.withSnsConfigs(instance.getSnsConfigs());
      this.withTelegramConfigs(instance.getTelegramConfigs());
      this.withVictoropsConfigs(instance.getVictoropsConfigs());
      this.withWebhookConfigs(instance.getWebhookConfigs());
      this.withWechatConfigs(instance.getWechatConfigs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReceiverFluent<?> fluent;
  Boolean validationEnabled;
  public Receiver build() {
    Receiver buildable = new Receiver(fluent.buildEmailConfigs(),fluent.getName(),fluent.buildOpsgenieConfigs(),fluent.buildPagerdutyConfigs(),fluent.buildPushoverConfigs(),fluent.buildSlackConfigs(),fluent.buildSnsConfigs(),fluent.buildTelegramConfigs(),fluent.buildVictoropsConfigs(),fluent.buildWebhookConfigs(),fluent.buildWechatConfigs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}