package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PagerDutyConfigBuilder extends PagerDutyConfigFluent<PagerDutyConfigBuilder> implements VisitableBuilder<PagerDutyConfig,PagerDutyConfigBuilder>{
  public PagerDutyConfigBuilder() {
    this(false);
  }
  public PagerDutyConfigBuilder(Boolean validationEnabled) {
    this(new PagerDutyConfig(), validationEnabled);
  }
  public PagerDutyConfigBuilder(PagerDutyConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public PagerDutyConfigBuilder(PagerDutyConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PagerDutyConfig(), validationEnabled);
  }
  public PagerDutyConfigBuilder(PagerDutyConfigFluent<?> fluent,PagerDutyConfig instance) {
    this(fluent, instance, false);
  }
  public PagerDutyConfigBuilder(PagerDutyConfigFluent<?> fluent,PagerDutyConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PagerDutyConfig());

    if (instance != null) {
      fluent.withClassName(instance.getClassName());
      fluent.withClient(instance.getClient());
      fluent.withClientURL(instance.getClientURL());
      fluent.withComponent(instance.getComponent());
      fluent.withDescription(instance.getDescription());
      fluent.withDetails(instance.getDetails());
      fluent.withGroup(instance.getGroup());
      fluent.withHttpConfig(instance.getHttpConfig());
      fluent.withPagerDutyImageConfigs(instance.getPagerDutyImageConfigs());
      fluent.withPagerDutyLinkConfigs(instance.getPagerDutyLinkConfigs());
      fluent.withRoutingKey(instance.getRoutingKey());
      fluent.withSendResolved(instance.getSendResolved());
      fluent.withServiceKey(instance.getServiceKey());
      fluent.withSeverity(instance.getSeverity());
      fluent.withUrl(instance.getUrl());
      fluent.withClassName(instance.getClassName());
      fluent.withClient(instance.getClient());
      fluent.withClientURL(instance.getClientURL());
      fluent.withComponent(instance.getComponent());
      fluent.withDescription(instance.getDescription());
      fluent.withDetails(instance.getDetails());
      fluent.withGroup(instance.getGroup());
      fluent.withHttpConfig(instance.getHttpConfig());
      fluent.withPagerDutyImageConfigs(instance.getPagerDutyImageConfigs());
      fluent.withPagerDutyLinkConfigs(instance.getPagerDutyLinkConfigs());
      fluent.withRoutingKey(instance.getRoutingKey());
      fluent.withSendResolved(instance.getSendResolved());
      fluent.withServiceKey(instance.getServiceKey());
      fluent.withSeverity(instance.getSeverity());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PagerDutyConfigBuilder(PagerDutyConfig instance) {
    this(instance,false);
  }
  public PagerDutyConfigBuilder(PagerDutyConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PagerDutyConfig());

    if (instance != null) {
      this.withClassName(instance.getClassName());
      this.withClient(instance.getClient());
      this.withClientURL(instance.getClientURL());
      this.withComponent(instance.getComponent());
      this.withDescription(instance.getDescription());
      this.withDetails(instance.getDetails());
      this.withGroup(instance.getGroup());
      this.withHttpConfig(instance.getHttpConfig());
      this.withPagerDutyImageConfigs(instance.getPagerDutyImageConfigs());
      this.withPagerDutyLinkConfigs(instance.getPagerDutyLinkConfigs());
      this.withRoutingKey(instance.getRoutingKey());
      this.withSendResolved(instance.getSendResolved());
      this.withServiceKey(instance.getServiceKey());
      this.withSeverity(instance.getSeverity());
      this.withUrl(instance.getUrl());
      this.withClassName(instance.getClassName());
      this.withClient(instance.getClient());
      this.withClientURL(instance.getClientURL());
      this.withComponent(instance.getComponent());
      this.withDescription(instance.getDescription());
      this.withDetails(instance.getDetails());
      this.withGroup(instance.getGroup());
      this.withHttpConfig(instance.getHttpConfig());
      this.withPagerDutyImageConfigs(instance.getPagerDutyImageConfigs());
      this.withPagerDutyLinkConfigs(instance.getPagerDutyLinkConfigs());
      this.withRoutingKey(instance.getRoutingKey());
      this.withSendResolved(instance.getSendResolved());
      this.withServiceKey(instance.getServiceKey());
      this.withSeverity(instance.getSeverity());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PagerDutyConfigFluent<?> fluent;
  Boolean validationEnabled;
  public PagerDutyConfig build() {
    PagerDutyConfig buildable = new PagerDutyConfig(fluent.getClassName(),fluent.getClient(),fluent.getClientURL(),fluent.getComponent(),fluent.getDescription(),fluent.buildDetails(),fluent.getGroup(),fluent.buildHttpConfig(),fluent.buildPagerDutyImageConfigs(),fluent.buildPagerDutyLinkConfigs(),fluent.getRoutingKey(),fluent.getSendResolved(),fluent.getServiceKey(),fluent.getSeverity(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}