package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpsGenieConfigBuilder extends OpsGenieConfigFluent<OpsGenieConfigBuilder> implements VisitableBuilder<OpsGenieConfig,OpsGenieConfigBuilder>{
  public OpsGenieConfigBuilder() {
    this(false);
  }
  public OpsGenieConfigBuilder(Boolean validationEnabled) {
    this(new OpsGenieConfig(), validationEnabled);
  }
  public OpsGenieConfigBuilder(OpsGenieConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public OpsGenieConfigBuilder(OpsGenieConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpsGenieConfig(), validationEnabled);
  }
  public OpsGenieConfigBuilder(OpsGenieConfigFluent<?> fluent,OpsGenieConfig instance) {
    this(fluent, instance, false);
  }
  public OpsGenieConfigBuilder(OpsGenieConfigFluent<?> fluent,OpsGenieConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OpsGenieConfig());

    if (instance != null) {
      fluent.withActions(instance.getActions());
      fluent.withApiKey(instance.getApiKey());
      fluent.withApiURL(instance.getApiURL());
      fluent.withDescription(instance.getDescription());
      fluent.withDetails(instance.getDetails());
      fluent.withEntity(instance.getEntity());
      fluent.withHttpConfig(instance.getHttpConfig());
      fluent.withMessage(instance.getMessage());
      fluent.withNote(instance.getNote());
      fluent.withPriority(instance.getPriority());
      fluent.withResponders(instance.getResponders());
      fluent.withSendResolved(instance.getSendResolved());
      fluent.withSource(instance.getSource());
      fluent.withTags(instance.getTags());
      fluent.withUpdateAlerts(instance.getUpdateAlerts());
      fluent.withActions(instance.getActions());
      fluent.withApiKey(instance.getApiKey());
      fluent.withApiURL(instance.getApiURL());
      fluent.withDescription(instance.getDescription());
      fluent.withDetails(instance.getDetails());
      fluent.withEntity(instance.getEntity());
      fluent.withHttpConfig(instance.getHttpConfig());
      fluent.withMessage(instance.getMessage());
      fluent.withNote(instance.getNote());
      fluent.withPriority(instance.getPriority());
      fluent.withResponders(instance.getResponders());
      fluent.withSendResolved(instance.getSendResolved());
      fluent.withSource(instance.getSource());
      fluent.withTags(instance.getTags());
      fluent.withUpdateAlerts(instance.getUpdateAlerts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpsGenieConfigBuilder(OpsGenieConfig instance) {
    this(instance,false);
  }
  public OpsGenieConfigBuilder(OpsGenieConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OpsGenieConfig());

    if (instance != null) {
      this.withActions(instance.getActions());
      this.withApiKey(instance.getApiKey());
      this.withApiURL(instance.getApiURL());
      this.withDescription(instance.getDescription());
      this.withDetails(instance.getDetails());
      this.withEntity(instance.getEntity());
      this.withHttpConfig(instance.getHttpConfig());
      this.withMessage(instance.getMessage());
      this.withNote(instance.getNote());
      this.withPriority(instance.getPriority());
      this.withResponders(instance.getResponders());
      this.withSendResolved(instance.getSendResolved());
      this.withSource(instance.getSource());
      this.withTags(instance.getTags());
      this.withUpdateAlerts(instance.getUpdateAlerts());
      this.withActions(instance.getActions());
      this.withApiKey(instance.getApiKey());
      this.withApiURL(instance.getApiURL());
      this.withDescription(instance.getDescription());
      this.withDetails(instance.getDetails());
      this.withEntity(instance.getEntity());
      this.withHttpConfig(instance.getHttpConfig());
      this.withMessage(instance.getMessage());
      this.withNote(instance.getNote());
      this.withPriority(instance.getPriority());
      this.withResponders(instance.getResponders());
      this.withSendResolved(instance.getSendResolved());
      this.withSource(instance.getSource());
      this.withTags(instance.getTags());
      this.withUpdateAlerts(instance.getUpdateAlerts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpsGenieConfigFluent<?> fluent;
  Boolean validationEnabled;
  public OpsGenieConfig build() {
    OpsGenieConfig buildable = new OpsGenieConfig(fluent.getActions(),fluent.getApiKey(),fluent.getApiURL(),fluent.getDescription(),fluent.buildDetails(),fluent.getEntity(),fluent.buildHttpConfig(),fluent.getMessage(),fluent.getNote(),fluent.getPriority(),fluent.buildResponders(),fluent.getSendResolved(),fluent.getSource(),fluent.getTags(),fluent.getUpdateAlerts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}