package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MuteTimeIntervalBuilder extends MuteTimeIntervalFluent<MuteTimeIntervalBuilder> implements VisitableBuilder<MuteTimeInterval,MuteTimeIntervalBuilder>{
  public MuteTimeIntervalBuilder() {
    this(false);
  }
  public MuteTimeIntervalBuilder(Boolean validationEnabled) {
    this(new MuteTimeInterval(), validationEnabled);
  }
  public MuteTimeIntervalBuilder(MuteTimeIntervalFluent<?> fluent) {
    this(fluent, false);
  }
  public MuteTimeIntervalBuilder(MuteTimeIntervalFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MuteTimeInterval(), validationEnabled);
  }
  public MuteTimeIntervalBuilder(MuteTimeIntervalFluent<?> fluent,MuteTimeInterval instance) {
    this(fluent, instance, false);
  }
  public MuteTimeIntervalBuilder(MuteTimeIntervalFluent<?> fluent,MuteTimeInterval instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MuteTimeInterval());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withTimeIntervals(instance.getTimeIntervals());
      fluent.withName(instance.getName());
      fluent.withTimeIntervals(instance.getTimeIntervals());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MuteTimeIntervalBuilder(MuteTimeInterval instance) {
    this(instance,false);
  }
  public MuteTimeIntervalBuilder(MuteTimeInterval instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MuteTimeInterval());

    if (instance != null) {
      this.withName(instance.getName());
      this.withTimeIntervals(instance.getTimeIntervals());
      this.withName(instance.getName());
      this.withTimeIntervals(instance.getTimeIntervals());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MuteTimeIntervalFluent<?> fluent;
  Boolean validationEnabled;
  public MuteTimeInterval build() {
    MuteTimeInterval buildable = new MuteTimeInterval(fluent.getName(),fluent.buildTimeIntervals());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}