package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MatcherBuilder extends MatcherFluent<MatcherBuilder> implements VisitableBuilder<Matcher,MatcherBuilder>{
  public MatcherBuilder() {
    this(false);
  }
  public MatcherBuilder(Boolean validationEnabled) {
    this(new Matcher(), validationEnabled);
  }
  public MatcherBuilder(MatcherFluent<?> fluent) {
    this(fluent, false);
  }
  public MatcherBuilder(MatcherFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Matcher(), validationEnabled);
  }
  public MatcherBuilder(MatcherFluent<?> fluent,Matcher instance) {
    this(fluent, instance, false);
  }
  public MatcherBuilder(MatcherFluent<?> fluent,Matcher instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Matcher());

    if (instance != null) {
      fluent.withMatchType(instance.getMatchType());
      fluent.withName(instance.getName());
      fluent.withRegex(instance.getRegex());
      fluent.withValue(instance.getValue());
      fluent.withMatchType(instance.getMatchType());
      fluent.withName(instance.getName());
      fluent.withRegex(instance.getRegex());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MatcherBuilder(Matcher instance) {
    this(instance,false);
  }
  public MatcherBuilder(Matcher instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Matcher());

    if (instance != null) {
      this.withMatchType(instance.getMatchType());
      this.withName(instance.getName());
      this.withRegex(instance.getRegex());
      this.withValue(instance.getValue());
      this.withMatchType(instance.getMatchType());
      this.withName(instance.getName());
      this.withRegex(instance.getRegex());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MatcherFluent<?> fluent;
  Boolean validationEnabled;
  public Matcher build() {
    Matcher buildable = new Matcher(fluent.getMatchType(),fluent.getName(),fluent.getRegex(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}