package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DayOfMonthRangeBuilder extends DayOfMonthRangeFluent<DayOfMonthRangeBuilder> implements VisitableBuilder<DayOfMonthRange,DayOfMonthRangeBuilder>{
  public DayOfMonthRangeBuilder() {
    this(false);
  }
  public DayOfMonthRangeBuilder(Boolean validationEnabled) {
    this(new DayOfMonthRange(), validationEnabled);
  }
  public DayOfMonthRangeBuilder(DayOfMonthRangeFluent<?> fluent) {
    this(fluent, false);
  }
  public DayOfMonthRangeBuilder(DayOfMonthRangeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DayOfMonthRange(), validationEnabled);
  }
  public DayOfMonthRangeBuilder(DayOfMonthRangeFluent<?> fluent,DayOfMonthRange instance) {
    this(fluent, instance, false);
  }
  public DayOfMonthRangeBuilder(DayOfMonthRangeFluent<?> fluent,DayOfMonthRange instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DayOfMonthRange());

    if (instance != null) {
      fluent.withEnd(instance.getEnd());
      fluent.withStart(instance.getStart());
      fluent.withEnd(instance.getEnd());
      fluent.withStart(instance.getStart());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DayOfMonthRangeBuilder(DayOfMonthRange instance) {
    this(instance,false);
  }
  public DayOfMonthRangeBuilder(DayOfMonthRange instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DayOfMonthRange());

    if (instance != null) {
      this.withEnd(instance.getEnd());
      this.withStart(instance.getStart());
      this.withEnd(instance.getEnd());
      this.withStart(instance.getStart());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DayOfMonthRangeFluent<?> fluent;
  Boolean validationEnabled;
  public DayOfMonthRange build() {
    DayOfMonthRange buildable = new DayOfMonthRange(fluent.getEnd(),fluent.getStart());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}