package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebTLSConfigBuilder extends WebTLSConfigFluent<WebTLSConfigBuilder> implements VisitableBuilder<WebTLSConfig,WebTLSConfigBuilder>{
  public WebTLSConfigBuilder() {
    this(false);
  }
  public WebTLSConfigBuilder(Boolean validationEnabled) {
    this(new WebTLSConfig(), validationEnabled);
  }
  public WebTLSConfigBuilder(WebTLSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public WebTLSConfigBuilder(WebTLSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WebTLSConfig(), validationEnabled);
  }
  public WebTLSConfigBuilder(WebTLSConfigFluent<?> fluent,WebTLSConfig instance) {
    this(fluent, instance, false);
  }
  public WebTLSConfigBuilder(WebTLSConfigFluent<?> fluent,WebTLSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WebTLSConfig());

    if (instance != null) {
      fluent.withCert(instance.getCert());
      fluent.withCipherSuites(instance.getCipherSuites());
      fluent.withClientAuthType(instance.getClientAuthType());
      fluent.withClientCa(instance.getClientCa());
      fluent.withCurvePreferences(instance.getCurvePreferences());
      fluent.withKeySecret(instance.getKeySecret());
      fluent.withMaxVersion(instance.getMaxVersion());
      fluent.withMinVersion(instance.getMinVersion());
      fluent.withPreferServerCipherSuites(instance.getPreferServerCipherSuites());
      fluent.withCert(instance.getCert());
      fluent.withCipherSuites(instance.getCipherSuites());
      fluent.withClientAuthType(instance.getClientAuthType());
      fluent.withClientCa(instance.getClientCa());
      fluent.withCurvePreferences(instance.getCurvePreferences());
      fluent.withKeySecret(instance.getKeySecret());
      fluent.withMaxVersion(instance.getMaxVersion());
      fluent.withMinVersion(instance.getMinVersion());
      fluent.withPreferServerCipherSuites(instance.getPreferServerCipherSuites());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WebTLSConfigBuilder(WebTLSConfig instance) {
    this(instance,false);
  }
  public WebTLSConfigBuilder(WebTLSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WebTLSConfig());

    if (instance != null) {
      this.withCert(instance.getCert());
      this.withCipherSuites(instance.getCipherSuites());
      this.withClientAuthType(instance.getClientAuthType());
      this.withClientCa(instance.getClientCa());
      this.withCurvePreferences(instance.getCurvePreferences());
      this.withKeySecret(instance.getKeySecret());
      this.withMaxVersion(instance.getMaxVersion());
      this.withMinVersion(instance.getMinVersion());
      this.withPreferServerCipherSuites(instance.getPreferServerCipherSuites());
      this.withCert(instance.getCert());
      this.withCipherSuites(instance.getCipherSuites());
      this.withClientAuthType(instance.getClientAuthType());
      this.withClientCa(instance.getClientCa());
      this.withCurvePreferences(instance.getCurvePreferences());
      this.withKeySecret(instance.getKeySecret());
      this.withMaxVersion(instance.getMaxVersion());
      this.withMinVersion(instance.getMinVersion());
      this.withPreferServerCipherSuites(instance.getPreferServerCipherSuites());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WebTLSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public WebTLSConfig build() {
    WebTLSConfig buildable = new WebTLSConfig(fluent.buildCert(),fluent.getCipherSuites(),fluent.getClientAuthType(),fluent.buildClientCa(),fluent.getCurvePreferences(),fluent.getKeySecret(),fluent.getMaxVersion(),fluent.getMinVersion(),fluent.getPreferServerCipherSuites());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}