package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebSpecBuilder extends WebSpecFluent<WebSpecBuilder> implements VisitableBuilder<WebSpec,WebSpecBuilder>{
  public WebSpecBuilder() {
    this(false);
  }
  public WebSpecBuilder(Boolean validationEnabled) {
    this(new WebSpec(), validationEnabled);
  }
  public WebSpecBuilder(WebSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public WebSpecBuilder(WebSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WebSpec(), validationEnabled);
  }
  public WebSpecBuilder(WebSpecFluent<?> fluent,WebSpec instance) {
    this(fluent, instance, false);
  }
  public WebSpecBuilder(WebSpecFluent<?> fluent,WebSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WebSpec());

    if (instance != null) {
      fluent.withPageTitle(instance.getPageTitle());
      fluent.withTlsConfig(instance.getTlsConfig());
      fluent.withPageTitle(instance.getPageTitle());
      fluent.withTlsConfig(instance.getTlsConfig());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WebSpecBuilder(WebSpec instance) {
    this(instance,false);
  }
  public WebSpecBuilder(WebSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WebSpec());

    if (instance != null) {
      this.withPageTitle(instance.getPageTitle());
      this.withTlsConfig(instance.getTlsConfig());
      this.withPageTitle(instance.getPageTitle());
      this.withTlsConfig(instance.getTlsConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WebSpecFluent<?> fluent;
  Boolean validationEnabled;
  public WebSpec build() {
    WebSpec buildable = new WebSpec(fluent.getPageTitle(),fluent.buildTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}