package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ThanosRulerBuilder extends ThanosRulerFluent<ThanosRulerBuilder> implements VisitableBuilder<ThanosRuler,ThanosRulerBuilder>{
  public ThanosRulerBuilder() {
    this(false);
  }
  public ThanosRulerBuilder(Boolean validationEnabled) {
    this(new ThanosRuler(), validationEnabled);
  }
  public ThanosRulerBuilder(ThanosRulerFluent<?> fluent) {
    this(fluent, false);
  }
  public ThanosRulerBuilder(ThanosRulerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ThanosRuler(), validationEnabled);
  }
  public ThanosRulerBuilder(ThanosRulerFluent<?> fluent,ThanosRuler instance) {
    this(fluent, instance, false);
  }
  public ThanosRulerBuilder(ThanosRulerFluent<?> fluent,ThanosRuler instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ThanosRuler());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ThanosRulerBuilder(ThanosRuler instance) {
    this(instance,false);
  }
  public ThanosRulerBuilder(ThanosRuler instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ThanosRuler());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ThanosRulerFluent<?> fluent;
  Boolean validationEnabled;
  public ThanosRuler build() {
    ThanosRuler buildable = new ThanosRuler(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}