package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageSpecBuilder extends StorageSpecFluent<StorageSpecBuilder> implements VisitableBuilder<StorageSpec,StorageSpecBuilder>{
  public StorageSpecBuilder() {
    this(false);
  }
  public StorageSpecBuilder(Boolean validationEnabled) {
    this(new StorageSpec(), validationEnabled);
  }
  public StorageSpecBuilder(StorageSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageSpecBuilder(StorageSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageSpec(), validationEnabled);
  }
  public StorageSpecBuilder(StorageSpecFluent<?> fluent,StorageSpec instance) {
    this(fluent, instance, false);
  }
  public StorageSpecBuilder(StorageSpecFluent<?> fluent,StorageSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StorageSpec());

    if (instance != null) {
      fluent.withDisableMountSubPath(instance.getDisableMountSubPath());
      fluent.withEmptyDir(instance.getEmptyDir());
      fluent.withEphemeral(instance.getEphemeral());
      fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
      fluent.withDisableMountSubPath(instance.getDisableMountSubPath());
      fluent.withEmptyDir(instance.getEmptyDir());
      fluent.withEphemeral(instance.getEphemeral());
      fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageSpecBuilder(StorageSpec instance) {
    this(instance,false);
  }
  public StorageSpecBuilder(StorageSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StorageSpec());

    if (instance != null) {
      this.withDisableMountSubPath(instance.getDisableMountSubPath());
      this.withEmptyDir(instance.getEmptyDir());
      this.withEphemeral(instance.getEphemeral());
      this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
      this.withDisableMountSubPath(instance.getDisableMountSubPath());
      this.withEmptyDir(instance.getEmptyDir());
      this.withEphemeral(instance.getEphemeral());
      this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StorageSpec build() {
    StorageSpec buildable = new StorageSpec(fluent.getDisableMountSubPath(),fluent.getEmptyDir(),fluent.getEphemeral(),fluent.buildVolumeClaimTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}