package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class Sigv4Fluent<A extends Sigv4Fluent<A>> extends BaseFluent<A>{
  public Sigv4Fluent() {
  }
  public Sigv4Fluent(Sigv4 instance) {
    instance = (instance != null ? instance : new Sigv4());

    if (instance != null) {
      this.withAccessKey(instance.getAccessKey());
      this.withProfile(instance.getProfile());
      this.withRegion(instance.getRegion());
      this.withRoleArn(instance.getRoleArn());
      this.withSecretKey(instance.getSecretKey());
      this.withAccessKey(instance.getAccessKey());
      this.withProfile(instance.getProfile());
      this.withRegion(instance.getRegion());
      this.withRoleArn(instance.getRoleArn());
      this.withSecretKey(instance.getSecretKey());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SecretKeySelector accessKey;
  private String profile;
  private String region;
  private String roleArn;
  private SecretKeySelector secretKey;
  private Map<String,Object> additionalProperties;
  public SecretKeySelector getAccessKey() {
    return this.accessKey;
  }
  public A withAccessKey(SecretKeySelector accessKey) {
    this.accessKey=accessKey; return (A) this;
  }
  public boolean hasAccessKey() {
    return this.accessKey != null;
  }
  public A withNewAccessKey(String key,String name,Boolean optional) {
    return (A)withAccessKey(new SecretKeySelector(key, name, optional));
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public boolean hasProfile() {
    return this.profile != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public boolean hasRegion() {
    return this.region != null;
  }
  public String getRoleArn() {
    return this.roleArn;
  }
  public A withRoleArn(String roleArn) {
    this.roleArn=roleArn; return (A) this;
  }
  public boolean hasRoleArn() {
    return this.roleArn != null;
  }
  public SecretKeySelector getSecretKey() {
    return this.secretKey;
  }
  public A withSecretKey(SecretKeySelector secretKey) {
    this.secretKey=secretKey; return (A) this;
  }
  public boolean hasSecretKey() {
    return this.secretKey != null;
  }
  public A withNewSecretKey(String key,String name,Boolean optional) {
    return (A)withSecretKey(new SecretKeySelector(key, name, optional));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Sigv4Fluent that = (Sigv4Fluent) o;
    if (!java.util.Objects.equals(accessKey, that.accessKey)) return false;

    if (!java.util.Objects.equals(profile, that.profile)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(roleArn, that.roleArn)) return false;

    if (!java.util.Objects.equals(secretKey, that.secretKey)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessKey,  profile,  region,  roleArn,  secretKey,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessKey != null) { sb.append("accessKey:"); sb.append(accessKey + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (roleArn != null) { sb.append("roleArn:"); sb.append(roleArn + ","); }
    if (secretKey != null) { sb.append("secretKey:"); sb.append(secretKey + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}