package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ShardStatusBuilder extends ShardStatusFluent<ShardStatusBuilder> implements VisitableBuilder<ShardStatus,ShardStatusBuilder>{
  public ShardStatusBuilder() {
    this(false);
  }
  public ShardStatusBuilder(Boolean validationEnabled) {
    this(new ShardStatus(), validationEnabled);
  }
  public ShardStatusBuilder(ShardStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ShardStatusBuilder(ShardStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ShardStatus(), validationEnabled);
  }
  public ShardStatusBuilder(ShardStatusFluent<?> fluent,ShardStatus instance) {
    this(fluent, instance, false);
  }
  public ShardStatusBuilder(ShardStatusFluent<?> fluent,ShardStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ShardStatus());

    if (instance != null) {
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withShardID(instance.getShardID());
      fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
      fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withShardID(instance.getShardID());
      fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
      fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ShardStatusBuilder(ShardStatus instance) {
    this(instance,false);
  }
  public ShardStatusBuilder(ShardStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ShardStatus());

    if (instance != null) {
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withReplicas(instance.getReplicas());
      this.withShardID(instance.getShardID());
      this.withUnavailableReplicas(instance.getUnavailableReplicas());
      this.withUpdatedReplicas(instance.getUpdatedReplicas());
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withReplicas(instance.getReplicas());
      this.withShardID(instance.getShardID());
      this.withUnavailableReplicas(instance.getUnavailableReplicas());
      this.withUpdatedReplicas(instance.getUpdatedReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ShardStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ShardStatus build() {
    ShardStatus buildable = new ShardStatus(fluent.getAvailableReplicas(),fluent.getReplicas(),fluent.getShardID(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}