package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SafeTLSConfigFluent<A extends SafeTLSConfigFluent<A>> extends BaseFluent<A>{
  public SafeTLSConfigFluent() {
  }
  public SafeTLSConfigFluent(SafeTLSConfig instance) {
    instance = (instance != null ? instance : new SafeTLSConfig());

    if (instance != null) {
      this.withCa(instance.getCa());
      this.withCert(instance.getCert());
      this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      this.withKeySecret(instance.getKeySecret());
      this.withServerName(instance.getServerName());
      this.withCa(instance.getCa());
      this.withCert(instance.getCert());
      this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      this.withKeySecret(instance.getKeySecret());
      this.withServerName(instance.getServerName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SecretOrConfigMapBuilder ca;
  private SecretOrConfigMapBuilder cert;
  private Boolean insecureSkipVerify;
  private SecretKeySelector keySecret;
  private String serverName;
  private Map<String,Object> additionalProperties;
  public SecretOrConfigMap buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(SecretOrConfigMap ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new SecretOrConfigMapBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public boolean hasCa() {
    return this.ca != null;
  }
  public CaNested<A> withNewCa() {
    return new CaNested(null);
  }
  public CaNested<A> withNewCaLike(SecretOrConfigMap item) {
    return new CaNested(item);
  }
  public CaNested<A> editCa() {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(null));
  }
  public CaNested<A> editOrNewCa() {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(new SecretOrConfigMapBuilder().build()));
  }
  public CaNested<A> editOrNewCaLike(SecretOrConfigMap item) {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(item));
  }
  public SecretOrConfigMap buildCert() {
    return this.cert!=null ?this.cert.build():null;
  }
  public A withCert(SecretOrConfigMap cert) {
    _visitables.get("cert").remove(this.cert);
    if (cert!=null){ this.cert= new SecretOrConfigMapBuilder(cert); _visitables.get("cert").add(this.cert);} else { this.cert = null; _visitables.get("cert").remove(this.cert); } return (A) this;
  }
  public boolean hasCert() {
    return this.cert != null;
  }
  public CertNested<A> withNewCert() {
    return new CertNested(null);
  }
  public CertNested<A> withNewCertLike(SecretOrConfigMap item) {
    return new CertNested(item);
  }
  public CertNested<A> editCert() {
    return withNewCertLike(java.util.Optional.ofNullable(buildCert()).orElse(null));
  }
  public CertNested<A> editOrNewCert() {
    return withNewCertLike(java.util.Optional.ofNullable(buildCert()).orElse(new SecretOrConfigMapBuilder().build()));
  }
  public CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
    return withNewCertLike(java.util.Optional.ofNullable(buildCert()).orElse(item));
  }
  public Boolean getInsecureSkipVerify() {
    return this.insecureSkipVerify;
  }
  public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
    this.insecureSkipVerify=insecureSkipVerify; return (A) this;
  }
  public boolean hasInsecureSkipVerify() {
    return this.insecureSkipVerify != null;
  }
  public SecretKeySelector getKeySecret() {
    return this.keySecret;
  }
  public A withKeySecret(SecretKeySelector keySecret) {
    this.keySecret=keySecret; return (A) this;
  }
  public boolean hasKeySecret() {
    return this.keySecret != null;
  }
  public A withNewKeySecret(String key,String name,Boolean optional) {
    return (A)withKeySecret(new SecretKeySelector(key, name, optional));
  }
  public String getServerName() {
    return this.serverName;
  }
  public A withServerName(String serverName) {
    this.serverName=serverName; return (A) this;
  }
  public boolean hasServerName() {
    return this.serverName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SafeTLSConfigFluent that = (SafeTLSConfigFluent) o;
    if (!java.util.Objects.equals(ca, that.ca)) return false;

    if (!java.util.Objects.equals(cert, that.cert)) return false;

    if (!java.util.Objects.equals(insecureSkipVerify, that.insecureSkipVerify)) return false;

    if (!java.util.Objects.equals(keySecret, that.keySecret)) return false;

    if (!java.util.Objects.equals(serverName, that.serverName)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  cert,  insecureSkipVerify,  keySecret,  serverName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (cert != null) { sb.append("cert:"); sb.append(cert + ","); }
    if (insecureSkipVerify != null) { sb.append("insecureSkipVerify:"); sb.append(insecureSkipVerify + ","); }
    if (keySecret != null) { sb.append("keySecret:"); sb.append(keySecret + ","); }
    if (serverName != null) { sb.append("serverName:"); sb.append(serverName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withInsecureSkipVerify() {
    return withInsecureSkipVerify(true);
  }
  public class CaNested<N> extends SecretOrConfigMapFluent<CaNested<N>> implements Nested<N>{
    CaNested(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) SafeTLSConfigFluent.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  public class CertNested<N> extends SecretOrConfigMapFluent<CertNested<N>> implements Nested<N>{
    CertNested(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) SafeTLSConfigFluent.this.withCert(builder.build());
    }
    public N endCert() {
      return and();
    }
    
  }
  
}