package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RulesBuilder extends RulesFluent<RulesBuilder> implements VisitableBuilder<Rules,RulesBuilder>{
  public RulesBuilder() {
    this(false);
  }
  public RulesBuilder(Boolean validationEnabled) {
    this(new Rules(), validationEnabled);
  }
  public RulesBuilder(RulesFluent<?> fluent) {
    this(fluent, false);
  }
  public RulesBuilder(RulesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Rules(), validationEnabled);
  }
  public RulesBuilder(RulesFluent<?> fluent,Rules instance) {
    this(fluent, instance, false);
  }
  public RulesBuilder(RulesFluent<?> fluent,Rules instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Rules());

    if (instance != null) {
      fluent.withAlert(instance.getAlert());
      fluent.withAlert(instance.getAlert());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RulesBuilder(Rules instance) {
    this(instance,false);
  }
  public RulesBuilder(Rules instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Rules());

    if (instance != null) {
      this.withAlert(instance.getAlert());
      this.withAlert(instance.getAlert());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RulesFluent<?> fluent;
  Boolean validationEnabled;
  public Rules build() {
    Rules buildable = new Rules(fluent.buildAlert());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}