package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RulesAlertBuilder extends RulesAlertFluent<RulesAlertBuilder> implements VisitableBuilder<RulesAlert,RulesAlertBuilder>{
  public RulesAlertBuilder() {
    this(false);
  }
  public RulesAlertBuilder(Boolean validationEnabled) {
    this(new RulesAlert(), validationEnabled);
  }
  public RulesAlertBuilder(RulesAlertFluent<?> fluent) {
    this(fluent, false);
  }
  public RulesAlertBuilder(RulesAlertFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RulesAlert(), validationEnabled);
  }
  public RulesAlertBuilder(RulesAlertFluent<?> fluent,RulesAlert instance) {
    this(fluent, instance, false);
  }
  public RulesAlertBuilder(RulesAlertFluent<?> fluent,RulesAlert instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RulesAlert());

    if (instance != null) {
      fluent.withForGracePeriod(instance.getForGracePeriod());
      fluent.withForOutageTolerance(instance.getForOutageTolerance());
      fluent.withResendDelay(instance.getResendDelay());
      fluent.withForGracePeriod(instance.getForGracePeriod());
      fluent.withForOutageTolerance(instance.getForOutageTolerance());
      fluent.withResendDelay(instance.getResendDelay());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RulesAlertBuilder(RulesAlert instance) {
    this(instance,false);
  }
  public RulesAlertBuilder(RulesAlert instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RulesAlert());

    if (instance != null) {
      this.withForGracePeriod(instance.getForGracePeriod());
      this.withForOutageTolerance(instance.getForOutageTolerance());
      this.withResendDelay(instance.getResendDelay());
      this.withForGracePeriod(instance.getForGracePeriod());
      this.withForOutageTolerance(instance.getForOutageTolerance());
      this.withResendDelay(instance.getResendDelay());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RulesAlertFluent<?> fluent;
  Boolean validationEnabled;
  public RulesAlert build() {
    RulesAlert buildable = new RulesAlert(fluent.getForGracePeriod(),fluent.getForOutageTolerance(),fluent.getResendDelay());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}