package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RuleFluent<A extends RuleFluent<A>> extends BaseFluent<A>{
  public RuleFluent() {
  }
  public RuleFluent(Rule instance) {
    instance = (instance != null ? instance : new Rule());

    if (instance != null) {
      this.withAlert(instance.getAlert());
      this.withAnnotations(instance.getAnnotations());
      this.withExpr(instance.getExpr());
      this.withFor(instance.getFor());
      this.withLabels(instance.getLabels());
      this.withRecord(instance.getRecord());
      this.withAlert(instance.getAlert());
      this.withAnnotations(instance.getAnnotations());
      this.withExpr(instance.getExpr());
      this.withFor(instance.getFor());
      this.withLabels(instance.getLabels());
      this.withRecord(instance.getRecord());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String alert;
  private Map<String,String> annotations;
  private IntOrStringBuilder expr;
  private String _for;
  private Map<String,String> labels;
  private String record;
  private Map<String,Object> additionalProperties;
  public String getAlert() {
    return this.alert;
  }
  public A withAlert(String alert) {
    this.alert=alert; return (A) this;
  }
  public boolean hasAlert() {
    return this.alert != null;
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  public IntOrString buildExpr() {
    return this.expr!=null ?this.expr.build():null;
  }
  public A withExpr(IntOrString expr) {
    _visitables.get("expr").remove(this.expr);
    if (expr!=null){ this.expr= new IntOrStringBuilder(expr); _visitables.get("expr").add(this.expr);} else { this.expr = null; _visitables.get("expr").remove(this.expr); } return (A) this;
  }
  public boolean hasExpr() {
    return this.expr != null;
  }
  public A withNewExpr(Object value) {
    return (A)withExpr(new IntOrString(value));
  }
  public ExprNested<A> withNewExpr() {
    return new ExprNested(null);
  }
  public ExprNested<A> withNewExprLike(IntOrString item) {
    return new ExprNested(item);
  }
  public ExprNested<A> editExpr() {
    return withNewExprLike(java.util.Optional.ofNullable(buildExpr()).orElse(null));
  }
  public ExprNested<A> editOrNewExpr() {
    return withNewExprLike(java.util.Optional.ofNullable(buildExpr()).orElse(new IntOrStringBuilder().build()));
  }
  public ExprNested<A> editOrNewExprLike(IntOrString item) {
    return withNewExprLike(java.util.Optional.ofNullable(buildExpr()).orElse(item));
  }
  public String getFor() {
    return this._for;
  }
  public A withFor(String _for) {
    this._for=_for; return (A) this;
  }
  public boolean hasFor() {
    return this._for != null;
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public boolean hasLabels() {
    return this.labels != null;
  }
  public String getRecord() {
    return this.record;
  }
  public A withRecord(String record) {
    this.record=record; return (A) this;
  }
  public boolean hasRecord() {
    return this.record != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuleFluent that = (RuleFluent) o;
    if (!java.util.Objects.equals(alert, that.alert)) return false;

    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(expr, that.expr)) return false;

    if (!java.util.Objects.equals(_for, that._for)) return false;

    if (!java.util.Objects.equals(labels, that.labels)) return false;

    if (!java.util.Objects.equals(record, that.record)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(alert,  annotations,  expr,  _for,  labels,  record,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alert != null) { sb.append("alert:"); sb.append(alert + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (expr != null) { sb.append("expr:"); sb.append(expr + ","); }
    if (_for != null) { sb.append("_for:"); sb.append(_for + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (record != null) { sb.append("record:"); sb.append(record + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ExprNested<N> extends IntOrStringFluent<ExprNested<N>> implements Nested<N>{
    ExprNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) RuleFluent.this.withExpr(builder.build());
    }
    public N endExpr() {
      return and();
    }
    
  }
  
}