package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RemoteReadSpecBuilder extends RemoteReadSpecFluent<RemoteReadSpecBuilder> implements VisitableBuilder<RemoteReadSpec,RemoteReadSpecBuilder>{
  public RemoteReadSpecBuilder() {
    this(false);
  }
  public RemoteReadSpecBuilder(Boolean validationEnabled) {
    this(new RemoteReadSpec(), validationEnabled);
  }
  public RemoteReadSpecBuilder(RemoteReadSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RemoteReadSpecBuilder(RemoteReadSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RemoteReadSpec(), validationEnabled);
  }
  public RemoteReadSpecBuilder(RemoteReadSpecFluent<?> fluent,RemoteReadSpec instance) {
    this(fluent, instance, false);
  }
  public RemoteReadSpecBuilder(RemoteReadSpecFluent<?> fluent,RemoteReadSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RemoteReadSpec());

    if (instance != null) {
      fluent.withAuthorization(instance.getAuthorization());
      fluent.withBasicAuth(instance.getBasicAuth());
      fluent.withBearerToken(instance.getBearerToken());
      fluent.withBearerTokenFile(instance.getBearerTokenFile());
      fluent.withHeaders(instance.getHeaders());
      fluent.withName(instance.getName());
      fluent.withOauth2(instance.getOauth2());
      fluent.withProxyUrl(instance.getProxyUrl());
      fluent.withReadRecent(instance.getReadRecent());
      fluent.withRemoteTimeout(instance.getRemoteTimeout());
      fluent.withRequiredMatchers(instance.getRequiredMatchers());
      fluent.withTlsConfig(instance.getTlsConfig());
      fluent.withUrl(instance.getUrl());
      fluent.withAuthorization(instance.getAuthorization());
      fluent.withBasicAuth(instance.getBasicAuth());
      fluent.withBearerToken(instance.getBearerToken());
      fluent.withBearerTokenFile(instance.getBearerTokenFile());
      fluent.withHeaders(instance.getHeaders());
      fluent.withName(instance.getName());
      fluent.withOauth2(instance.getOauth2());
      fluent.withProxyUrl(instance.getProxyUrl());
      fluent.withReadRecent(instance.getReadRecent());
      fluent.withRemoteTimeout(instance.getRemoteTimeout());
      fluent.withRequiredMatchers(instance.getRequiredMatchers());
      fluent.withTlsConfig(instance.getTlsConfig());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RemoteReadSpecBuilder(RemoteReadSpec instance) {
    this(instance,false);
  }
  public RemoteReadSpecBuilder(RemoteReadSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RemoteReadSpec());

    if (instance != null) {
      this.withAuthorization(instance.getAuthorization());
      this.withBasicAuth(instance.getBasicAuth());
      this.withBearerToken(instance.getBearerToken());
      this.withBearerTokenFile(instance.getBearerTokenFile());
      this.withHeaders(instance.getHeaders());
      this.withName(instance.getName());
      this.withOauth2(instance.getOauth2());
      this.withProxyUrl(instance.getProxyUrl());
      this.withReadRecent(instance.getReadRecent());
      this.withRemoteTimeout(instance.getRemoteTimeout());
      this.withRequiredMatchers(instance.getRequiredMatchers());
      this.withTlsConfig(instance.getTlsConfig());
      this.withUrl(instance.getUrl());
      this.withAuthorization(instance.getAuthorization());
      this.withBasicAuth(instance.getBasicAuth());
      this.withBearerToken(instance.getBearerToken());
      this.withBearerTokenFile(instance.getBearerTokenFile());
      this.withHeaders(instance.getHeaders());
      this.withName(instance.getName());
      this.withOauth2(instance.getOauth2());
      this.withProxyUrl(instance.getProxyUrl());
      this.withReadRecent(instance.getReadRecent());
      this.withRemoteTimeout(instance.getRemoteTimeout());
      this.withRequiredMatchers(instance.getRequiredMatchers());
      this.withTlsConfig(instance.getTlsConfig());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RemoteReadSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RemoteReadSpec build() {
    RemoteReadSpec buildable = new RemoteReadSpec(fluent.buildAuthorization(),fluent.buildBasicAuth(),fluent.getBearerToken(),fluent.getBearerTokenFile(),fluent.getHeaders(),fluent.getName(),fluent.buildOauth2(),fluent.getProxyUrl(),fluent.getReadRecent(),fluent.getRemoteTimeout(),fluent.getRequiredMatchers(),fluent.buildTlsConfig(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}