package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RelabelConfigBuilder extends RelabelConfigFluent<RelabelConfigBuilder> implements VisitableBuilder<RelabelConfig,RelabelConfigBuilder>{
  public RelabelConfigBuilder() {
    this(false);
  }
  public RelabelConfigBuilder(Boolean validationEnabled) {
    this(new RelabelConfig(), validationEnabled);
  }
  public RelabelConfigBuilder(RelabelConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public RelabelConfigBuilder(RelabelConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RelabelConfig(), validationEnabled);
  }
  public RelabelConfigBuilder(RelabelConfigFluent<?> fluent,RelabelConfig instance) {
    this(fluent, instance, false);
  }
  public RelabelConfigBuilder(RelabelConfigFluent<?> fluent,RelabelConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RelabelConfig());

    if (instance != null) {
      fluent.withAction(instance.getAction());
      fluent.withModulus(instance.getModulus());
      fluent.withRegex(instance.getRegex());
      fluent.withReplacement(instance.getReplacement());
      fluent.withSeparator(instance.getSeparator());
      fluent.withSourceLabels(instance.getSourceLabels());
      fluent.withTargetLabel(instance.getTargetLabel());
      fluent.withAction(instance.getAction());
      fluent.withModulus(instance.getModulus());
      fluent.withRegex(instance.getRegex());
      fluent.withReplacement(instance.getReplacement());
      fluent.withSeparator(instance.getSeparator());
      fluent.withSourceLabels(instance.getSourceLabels());
      fluent.withTargetLabel(instance.getTargetLabel());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RelabelConfigBuilder(RelabelConfig instance) {
    this(instance,false);
  }
  public RelabelConfigBuilder(RelabelConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RelabelConfig());

    if (instance != null) {
      this.withAction(instance.getAction());
      this.withModulus(instance.getModulus());
      this.withRegex(instance.getRegex());
      this.withReplacement(instance.getReplacement());
      this.withSeparator(instance.getSeparator());
      this.withSourceLabels(instance.getSourceLabels());
      this.withTargetLabel(instance.getTargetLabel());
      this.withAction(instance.getAction());
      this.withModulus(instance.getModulus());
      this.withRegex(instance.getRegex());
      this.withReplacement(instance.getReplacement());
      this.withSeparator(instance.getSeparator());
      this.withSourceLabels(instance.getSourceLabels());
      this.withTargetLabel(instance.getTargetLabel());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RelabelConfigFluent<?> fluent;
  Boolean validationEnabled;
  public RelabelConfig build() {
    RelabelConfig buildable = new RelabelConfig(fluent.getAction(),fluent.getModulus(),fluent.getRegex(),fluent.getReplacement(),fluent.getSeparator(),fluent.getSourceLabels(),fluent.getTargetLabel());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}