package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusRuleSpecBuilder extends PrometheusRuleSpecFluent<PrometheusRuleSpecBuilder> implements VisitableBuilder<PrometheusRuleSpec,PrometheusRuleSpecBuilder>{
  public PrometheusRuleSpecBuilder() {
    this(false);
  }
  public PrometheusRuleSpecBuilder(Boolean validationEnabled) {
    this(new PrometheusRuleSpec(), validationEnabled);
  }
  public PrometheusRuleSpecBuilder(PrometheusRuleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusRuleSpecBuilder(PrometheusRuleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrometheusRuleSpec(), validationEnabled);
  }
  public PrometheusRuleSpecBuilder(PrometheusRuleSpecFluent<?> fluent,PrometheusRuleSpec instance) {
    this(fluent, instance, false);
  }
  public PrometheusRuleSpecBuilder(PrometheusRuleSpecFluent<?> fluent,PrometheusRuleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PrometheusRuleSpec());

    if (instance != null) {
      fluent.withGroups(instance.getGroups());
      fluent.withGroups(instance.getGroups());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PrometheusRuleSpecBuilder(PrometheusRuleSpec instance) {
    this(instance,false);
  }
  public PrometheusRuleSpecBuilder(PrometheusRuleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PrometheusRuleSpec());

    if (instance != null) {
      this.withGroups(instance.getGroups());
      this.withGroups(instance.getGroups());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PrometheusRuleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PrometheusRuleSpec build() {
    PrometheusRuleSpec buildable = new PrometheusRuleSpec(fluent.buildGroups());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}