package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusConditionBuilder extends PrometheusConditionFluent<PrometheusConditionBuilder> implements VisitableBuilder<PrometheusCondition,PrometheusConditionBuilder>{
  public PrometheusConditionBuilder() {
    this(false);
  }
  public PrometheusConditionBuilder(Boolean validationEnabled) {
    this(new PrometheusCondition(), validationEnabled);
  }
  public PrometheusConditionBuilder(PrometheusConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusConditionBuilder(PrometheusConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrometheusCondition(), validationEnabled);
  }
  public PrometheusConditionBuilder(PrometheusConditionFluent<?> fluent,PrometheusCondition instance) {
    this(fluent, instance, false);
  }
  public PrometheusConditionBuilder(PrometheusConditionFluent<?> fluent,PrometheusCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PrometheusCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PrometheusConditionBuilder(PrometheusCondition instance) {
    this(instance,false);
  }
  public PrometheusConditionBuilder(PrometheusCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PrometheusCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PrometheusConditionFluent<?> fluent;
  Boolean validationEnabled;
  public PrometheusCondition build() {
    PrometheusCondition buildable = new PrometheusCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}