package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusBuilder extends PrometheusFluent<PrometheusBuilder> implements VisitableBuilder<Prometheus,PrometheusBuilder>{
  public PrometheusBuilder() {
    this(false);
  }
  public PrometheusBuilder(Boolean validationEnabled) {
    this(new Prometheus(), validationEnabled);
  }
  public PrometheusBuilder(PrometheusFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusBuilder(PrometheusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Prometheus(), validationEnabled);
  }
  public PrometheusBuilder(PrometheusFluent<?> fluent,Prometheus instance) {
    this(fluent, instance, false);
  }
  public PrometheusBuilder(PrometheusFluent<?> fluent,Prometheus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Prometheus());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PrometheusBuilder(Prometheus instance) {
    this(instance,false);
  }
  public PrometheusBuilder(Prometheus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Prometheus());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PrometheusFluent<?> fluent;
  Boolean validationEnabled;
  public Prometheus build() {
    Prometheus buildable = new Prometheus(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}