package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProbeTargetsFluent<A extends ProbeTargetsFluent<A>> extends BaseFluent<A>{
  public ProbeTargetsFluent() {
  }
  public ProbeTargetsFluent(ProbeTargets instance) {
    instance = (instance != null ? instance : new ProbeTargets());

    if (instance != null) {
      this.withIngress(instance.getIngress());
      this.withStaticConfig(instance.getStaticConfig());
      this.withIngress(instance.getIngress());
      this.withStaticConfig(instance.getStaticConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ProbeTargetIngressBuilder ingress;
  private ProbeTargetStaticConfigBuilder staticConfig;
  private Map<String,Object> additionalProperties;
  public ProbeTargetIngress buildIngress() {
    return this.ingress!=null ?this.ingress.build():null;
  }
  public A withIngress(ProbeTargetIngress ingress) {
    _visitables.get("ingress").remove(this.ingress);
    if (ingress!=null){ this.ingress= new ProbeTargetIngressBuilder(ingress); _visitables.get("ingress").add(this.ingress);} else { this.ingress = null; _visitables.get("ingress").remove(this.ingress); } return (A) this;
  }
  public boolean hasIngress() {
    return this.ingress != null;
  }
  public IngressNested<A> withNewIngress() {
    return new IngressNested(null);
  }
  public IngressNested<A> withNewIngressLike(ProbeTargetIngress item) {
    return new IngressNested(item);
  }
  public IngressNested<A> editIngress() {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(null));
  }
  public IngressNested<A> editOrNewIngress() {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(new ProbeTargetIngressBuilder().build()));
  }
  public IngressNested<A> editOrNewIngressLike(ProbeTargetIngress item) {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(item));
  }
  public ProbeTargetStaticConfig buildStaticConfig() {
    return this.staticConfig!=null ?this.staticConfig.build():null;
  }
  public A withStaticConfig(ProbeTargetStaticConfig staticConfig) {
    _visitables.get("staticConfig").remove(this.staticConfig);
    if (staticConfig!=null){ this.staticConfig= new ProbeTargetStaticConfigBuilder(staticConfig); _visitables.get("staticConfig").add(this.staticConfig);} else { this.staticConfig = null; _visitables.get("staticConfig").remove(this.staticConfig); } return (A) this;
  }
  public boolean hasStaticConfig() {
    return this.staticConfig != null;
  }
  public StaticConfigNested<A> withNewStaticConfig() {
    return new StaticConfigNested(null);
  }
  public StaticConfigNested<A> withNewStaticConfigLike(ProbeTargetStaticConfig item) {
    return new StaticConfigNested(item);
  }
  public StaticConfigNested<A> editStaticConfig() {
    return withNewStaticConfigLike(java.util.Optional.ofNullable(buildStaticConfig()).orElse(null));
  }
  public StaticConfigNested<A> editOrNewStaticConfig() {
    return withNewStaticConfigLike(java.util.Optional.ofNullable(buildStaticConfig()).orElse(new ProbeTargetStaticConfigBuilder().build()));
  }
  public StaticConfigNested<A> editOrNewStaticConfigLike(ProbeTargetStaticConfig item) {
    return withNewStaticConfigLike(java.util.Optional.ofNullable(buildStaticConfig()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProbeTargetsFluent that = (ProbeTargetsFluent) o;
    if (!java.util.Objects.equals(ingress, that.ingress)) return false;

    if (!java.util.Objects.equals(staticConfig, that.staticConfig)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ingress,  staticConfig,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ingress != null) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (staticConfig != null) { sb.append("staticConfig:"); sb.append(staticConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IngressNested<N> extends ProbeTargetIngressFluent<IngressNested<N>> implements Nested<N>{
    IngressNested(ProbeTargetIngress item) {
      this.builder = new ProbeTargetIngressBuilder(this, item);
    }
    ProbeTargetIngressBuilder builder;
    public N and() {
      return (N) ProbeTargetsFluent.this.withIngress(builder.build());
    }
    public N endIngress() {
      return and();
    }
    
  }
  public class StaticConfigNested<N> extends ProbeTargetStaticConfigFluent<StaticConfigNested<N>> implements Nested<N>{
    StaticConfigNested(ProbeTargetStaticConfig item) {
      this.builder = new ProbeTargetStaticConfigBuilder(this, item);
    }
    ProbeTargetStaticConfigBuilder builder;
    public N and() {
      return (N) ProbeTargetsFluent.this.withStaticConfig(builder.build());
    }
    public N endStaticConfig() {
      return and();
    }
    
  }
  
}