package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeTargetStaticConfigBuilder extends ProbeTargetStaticConfigFluent<ProbeTargetStaticConfigBuilder> implements VisitableBuilder<ProbeTargetStaticConfig,ProbeTargetStaticConfigBuilder>{
  public ProbeTargetStaticConfigBuilder() {
    this(false);
  }
  public ProbeTargetStaticConfigBuilder(Boolean validationEnabled) {
    this(new ProbeTargetStaticConfig(), validationEnabled);
  }
  public ProbeTargetStaticConfigBuilder(ProbeTargetStaticConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeTargetStaticConfigBuilder(ProbeTargetStaticConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProbeTargetStaticConfig(), validationEnabled);
  }
  public ProbeTargetStaticConfigBuilder(ProbeTargetStaticConfigFluent<?> fluent,ProbeTargetStaticConfig instance) {
    this(fluent, instance, false);
  }
  public ProbeTargetStaticConfigBuilder(ProbeTargetStaticConfigFluent<?> fluent,ProbeTargetStaticConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProbeTargetStaticConfig());

    if (instance != null) {
      fluent.withLabels(instance.getLabels());
      fluent.withRelabelingConfigs(instance.getRelabelingConfigs());
      fluent.withStatic(instance.getStatic());
      fluent.withLabels(instance.getLabels());
      fluent.withRelabelingConfigs(instance.getRelabelingConfigs());
      fluent.withStatic(instance.getStatic());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProbeTargetStaticConfigBuilder(ProbeTargetStaticConfig instance) {
    this(instance,false);
  }
  public ProbeTargetStaticConfigBuilder(ProbeTargetStaticConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProbeTargetStaticConfig());

    if (instance != null) {
      this.withLabels(instance.getLabels());
      this.withRelabelingConfigs(instance.getRelabelingConfigs());
      this.withStatic(instance.getStatic());
      this.withLabels(instance.getLabels());
      this.withRelabelingConfigs(instance.getRelabelingConfigs());
      this.withStatic(instance.getStatic());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProbeTargetStaticConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ProbeTargetStaticConfig build() {
    ProbeTargetStaticConfig buildable = new ProbeTargetStaticConfig(fluent.getLabels(),fluent.buildRelabelingConfigs(),fluent.getStatic());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}