package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeTargetIngressBuilder extends ProbeTargetIngressFluent<ProbeTargetIngressBuilder> implements VisitableBuilder<ProbeTargetIngress,ProbeTargetIngressBuilder>{
  public ProbeTargetIngressBuilder() {
    this(false);
  }
  public ProbeTargetIngressBuilder(Boolean validationEnabled) {
    this(new ProbeTargetIngress(), validationEnabled);
  }
  public ProbeTargetIngressBuilder(ProbeTargetIngressFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeTargetIngressBuilder(ProbeTargetIngressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProbeTargetIngress(), validationEnabled);
  }
  public ProbeTargetIngressBuilder(ProbeTargetIngressFluent<?> fluent,ProbeTargetIngress instance) {
    this(fluent, instance, false);
  }
  public ProbeTargetIngressBuilder(ProbeTargetIngressFluent<?> fluent,ProbeTargetIngress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProbeTargetIngress());

    if (instance != null) {
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withRelabelingConfigs(instance.getRelabelingConfigs());
      fluent.withSelector(instance.getSelector());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withRelabelingConfigs(instance.getRelabelingConfigs());
      fluent.withSelector(instance.getSelector());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProbeTargetIngressBuilder(ProbeTargetIngress instance) {
    this(instance,false);
  }
  public ProbeTargetIngressBuilder(ProbeTargetIngress instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProbeTargetIngress());

    if (instance != null) {
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withRelabelingConfigs(instance.getRelabelingConfigs());
      this.withSelector(instance.getSelector());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withRelabelingConfigs(instance.getRelabelingConfigs());
      this.withSelector(instance.getSelector());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProbeTargetIngressFluent<?> fluent;
  Boolean validationEnabled;
  public ProbeTargetIngress build() {
    ProbeTargetIngress buildable = new ProbeTargetIngress(fluent.buildNamespaceSelector(),fluent.buildRelabelingConfigs(),fluent.buildSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}