package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeSpecBuilder extends ProbeSpecFluent<ProbeSpecBuilder> implements VisitableBuilder<ProbeSpec,ProbeSpecBuilder>{
  public ProbeSpecBuilder() {
    this(false);
  }
  public ProbeSpecBuilder(Boolean validationEnabled) {
    this(new ProbeSpec(), validationEnabled);
  }
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProbeSpec(), validationEnabled);
  }
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent,ProbeSpec instance) {
    this(fluent, instance, false);
  }
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent,ProbeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProbeSpec());

    if (instance != null) {
      fluent.withAuthorization(instance.getAuthorization());
      fluent.withBasicAuth(instance.getBasicAuth());
      fluent.withBearerTokenSecret(instance.getBearerTokenSecret());
      fluent.withInterval(instance.getInterval());
      fluent.withJobName(instance.getJobName());
      fluent.withLabelLimit(instance.getLabelLimit());
      fluent.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
      fluent.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
      fluent.withMetricRelabelings(instance.getMetricRelabelings());
      fluent.withModule(instance.getModule());
      fluent.withOauth2(instance.getOauth2());
      fluent.withProber(instance.getProber());
      fluent.withSampleLimit(instance.getSampleLimit());
      fluent.withScrapeTimeout(instance.getScrapeTimeout());
      fluent.withTargetLimit(instance.getTargetLimit());
      fluent.withTargets(instance.getTargets());
      fluent.withTlsConfig(instance.getTlsConfig());
      fluent.withAuthorization(instance.getAuthorization());
      fluent.withBasicAuth(instance.getBasicAuth());
      fluent.withBearerTokenSecret(instance.getBearerTokenSecret());
      fluent.withInterval(instance.getInterval());
      fluent.withJobName(instance.getJobName());
      fluent.withLabelLimit(instance.getLabelLimit());
      fluent.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
      fluent.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
      fluent.withMetricRelabelings(instance.getMetricRelabelings());
      fluent.withModule(instance.getModule());
      fluent.withOauth2(instance.getOauth2());
      fluent.withProber(instance.getProber());
      fluent.withSampleLimit(instance.getSampleLimit());
      fluent.withScrapeTimeout(instance.getScrapeTimeout());
      fluent.withTargetLimit(instance.getTargetLimit());
      fluent.withTargets(instance.getTargets());
      fluent.withTlsConfig(instance.getTlsConfig());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProbeSpecBuilder(ProbeSpec instance) {
    this(instance,false);
  }
  public ProbeSpecBuilder(ProbeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProbeSpec());

    if (instance != null) {
      this.withAuthorization(instance.getAuthorization());
      this.withBasicAuth(instance.getBasicAuth());
      this.withBearerTokenSecret(instance.getBearerTokenSecret());
      this.withInterval(instance.getInterval());
      this.withJobName(instance.getJobName());
      this.withLabelLimit(instance.getLabelLimit());
      this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
      this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
      this.withMetricRelabelings(instance.getMetricRelabelings());
      this.withModule(instance.getModule());
      this.withOauth2(instance.getOauth2());
      this.withProber(instance.getProber());
      this.withSampleLimit(instance.getSampleLimit());
      this.withScrapeTimeout(instance.getScrapeTimeout());
      this.withTargetLimit(instance.getTargetLimit());
      this.withTargets(instance.getTargets());
      this.withTlsConfig(instance.getTlsConfig());
      this.withAuthorization(instance.getAuthorization());
      this.withBasicAuth(instance.getBasicAuth());
      this.withBearerTokenSecret(instance.getBearerTokenSecret());
      this.withInterval(instance.getInterval());
      this.withJobName(instance.getJobName());
      this.withLabelLimit(instance.getLabelLimit());
      this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
      this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
      this.withMetricRelabelings(instance.getMetricRelabelings());
      this.withModule(instance.getModule());
      this.withOauth2(instance.getOauth2());
      this.withProber(instance.getProber());
      this.withSampleLimit(instance.getSampleLimit());
      this.withScrapeTimeout(instance.getScrapeTimeout());
      this.withTargetLimit(instance.getTargetLimit());
      this.withTargets(instance.getTargets());
      this.withTlsConfig(instance.getTlsConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProbeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ProbeSpec build() {
    ProbeSpec buildable = new ProbeSpec(fluent.buildAuthorization(),fluent.buildBasicAuth(),fluent.getBearerTokenSecret(),fluent.getInterval(),fluent.getJobName(),fluent.getLabelLimit(),fluent.getLabelNameLengthLimit(),fluent.getLabelValueLengthLimit(),fluent.buildMetricRelabelings(),fluent.getModule(),fluent.buildOauth2(),fluent.buildProber(),fluent.getSampleLimit(),fluent.getScrapeTimeout(),fluent.getTargetLimit(),fluent.buildTargets(),fluent.buildTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}