package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeListBuilder extends ProbeListFluent<ProbeListBuilder> implements VisitableBuilder<ProbeList,ProbeListBuilder>{
  public ProbeListBuilder() {
    this(false);
  }
  public ProbeListBuilder(Boolean validationEnabled) {
    this(new ProbeList(), validationEnabled);
  }
  public ProbeListBuilder(ProbeListFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeListBuilder(ProbeListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProbeList(), validationEnabled);
  }
  public ProbeListBuilder(ProbeListFluent<?> fluent,ProbeList instance) {
    this(fluent, instance, false);
  }
  public ProbeListBuilder(ProbeListFluent<?> fluent,ProbeList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProbeList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProbeListBuilder(ProbeList instance) {
    this(instance,false);
  }
  public ProbeListBuilder(ProbeList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProbeList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProbeListFluent<?> fluent;
  Boolean validationEnabled;
  public ProbeList build() {
    ProbeList buildable = new ProbeList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}