package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodMonitorSpecBuilder extends PodMonitorSpecFluent<PodMonitorSpecBuilder> implements VisitableBuilder<PodMonitorSpec,PodMonitorSpecBuilder>{
  public PodMonitorSpecBuilder() {
    this(false);
  }
  public PodMonitorSpecBuilder(Boolean validationEnabled) {
    this(new PodMonitorSpec(), validationEnabled);
  }
  public PodMonitorSpecBuilder(PodMonitorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodMonitorSpecBuilder(PodMonitorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodMonitorSpec(), validationEnabled);
  }
  public PodMonitorSpecBuilder(PodMonitorSpecFluent<?> fluent,PodMonitorSpec instance) {
    this(fluent, instance, false);
  }
  public PodMonitorSpecBuilder(PodMonitorSpecFluent<?> fluent,PodMonitorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodMonitorSpec());

    if (instance != null) {
      fluent.withAttachMetadata(instance.getAttachMetadata());
      fluent.withJobLabel(instance.getJobLabel());
      fluent.withLabelLimit(instance.getLabelLimit());
      fluent.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
      fluent.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withPodMetricsEndpoints(instance.getPodMetricsEndpoints());
      fluent.withPodTargetLabels(instance.getPodTargetLabels());
      fluent.withSampleLimit(instance.getSampleLimit());
      fluent.withSelector(instance.getSelector());
      fluent.withTargetLimit(instance.getTargetLimit());
      fluent.withAttachMetadata(instance.getAttachMetadata());
      fluent.withJobLabel(instance.getJobLabel());
      fluent.withLabelLimit(instance.getLabelLimit());
      fluent.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
      fluent.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withPodMetricsEndpoints(instance.getPodMetricsEndpoints());
      fluent.withPodTargetLabels(instance.getPodTargetLabels());
      fluent.withSampleLimit(instance.getSampleLimit());
      fluent.withSelector(instance.getSelector());
      fluent.withTargetLimit(instance.getTargetLimit());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodMonitorSpecBuilder(PodMonitorSpec instance) {
    this(instance,false);
  }
  public PodMonitorSpecBuilder(PodMonitorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodMonitorSpec());

    if (instance != null) {
      this.withAttachMetadata(instance.getAttachMetadata());
      this.withJobLabel(instance.getJobLabel());
      this.withLabelLimit(instance.getLabelLimit());
      this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
      this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withPodMetricsEndpoints(instance.getPodMetricsEndpoints());
      this.withPodTargetLabels(instance.getPodTargetLabels());
      this.withSampleLimit(instance.getSampleLimit());
      this.withSelector(instance.getSelector());
      this.withTargetLimit(instance.getTargetLimit());
      this.withAttachMetadata(instance.getAttachMetadata());
      this.withJobLabel(instance.getJobLabel());
      this.withLabelLimit(instance.getLabelLimit());
      this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
      this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withPodMetricsEndpoints(instance.getPodMetricsEndpoints());
      this.withPodTargetLabels(instance.getPodTargetLabels());
      this.withSampleLimit(instance.getSampleLimit());
      this.withSelector(instance.getSelector());
      this.withTargetLimit(instance.getTargetLimit());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodMonitorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodMonitorSpec build() {
    PodMonitorSpec buildable = new PodMonitorSpec(fluent.buildAttachMetadata(),fluent.getJobLabel(),fluent.getLabelLimit(),fluent.getLabelNameLengthLimit(),fluent.getLabelValueLengthLimit(),fluent.buildNamespaceSelector(),fluent.buildPodMetricsEndpoints(),fluent.getPodTargetLabels(),fluent.getSampleLimit(),fluent.buildSelector(),fluent.getTargetLimit());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}