package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodMetricsEndpointTLSConfigBuilder extends PodMetricsEndpointTLSConfigFluent<PodMetricsEndpointTLSConfigBuilder> implements VisitableBuilder<PodMetricsEndpointTLSConfig,PodMetricsEndpointTLSConfigBuilder>{
  public PodMetricsEndpointTLSConfigBuilder() {
    this(false);
  }
  public PodMetricsEndpointTLSConfigBuilder(Boolean validationEnabled) {
    this(new PodMetricsEndpointTLSConfig(), validationEnabled);
  }
  public PodMetricsEndpointTLSConfigBuilder(PodMetricsEndpointTLSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public PodMetricsEndpointTLSConfigBuilder(PodMetricsEndpointTLSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodMetricsEndpointTLSConfig(), validationEnabled);
  }
  public PodMetricsEndpointTLSConfigBuilder(PodMetricsEndpointTLSConfigFluent<?> fluent,PodMetricsEndpointTLSConfig instance) {
    this(fluent, instance, false);
  }
  public PodMetricsEndpointTLSConfigBuilder(PodMetricsEndpointTLSConfigFluent<?> fluent,PodMetricsEndpointTLSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodMetricsEndpointTLSConfig());

    if (instance != null) {
      fluent.withCa(instance.getCa());
      fluent.withCert(instance.getCert());
      fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      fluent.withKeySecret(instance.getKeySecret());
      fluent.withServerName(instance.getServerName());
      fluent.withCa(instance.getCa());
      fluent.withCert(instance.getCert());
      fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      fluent.withKeySecret(instance.getKeySecret());
      fluent.withServerName(instance.getServerName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodMetricsEndpointTLSConfigBuilder(PodMetricsEndpointTLSConfig instance) {
    this(instance,false);
  }
  public PodMetricsEndpointTLSConfigBuilder(PodMetricsEndpointTLSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodMetricsEndpointTLSConfig());

    if (instance != null) {
      this.withCa(instance.getCa());
      this.withCert(instance.getCert());
      this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      this.withKeySecret(instance.getKeySecret());
      this.withServerName(instance.getServerName());
      this.withCa(instance.getCa());
      this.withCert(instance.getCert());
      this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      this.withKeySecret(instance.getKeySecret());
      this.withServerName(instance.getServerName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodMetricsEndpointTLSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public PodMetricsEndpointTLSConfig build() {
    PodMetricsEndpointTLSConfig buildable = new PodMetricsEndpointTLSConfig(fluent.buildCa(),fluent.buildCert(),fluent.getInsecureSkipVerify(),fluent.getKeySecret(),fluent.getServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}