package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodMetricsEndpointFluent<A extends PodMetricsEndpointFluent<A>> extends BaseFluent<A>{
  public PodMetricsEndpointFluent() {
  }
  public PodMetricsEndpointFluent(PodMetricsEndpoint instance) {
    instance = (instance != null ? instance : new PodMetricsEndpoint());

    if (instance != null) {
      this.withAuthorization(instance.getAuthorization());
      this.withBasicAuth(instance.getBasicAuth());
      this.withBearerTokenSecret(instance.getBearerTokenSecret());
      this.withFollowRedirects(instance.getFollowRedirects());
      this.withHonorLabels(instance.getHonorLabels());
      this.withHonorTimestamps(instance.getHonorTimestamps());
      this.withInterval(instance.getInterval());
      this.withMetricRelabelings(instance.getMetricRelabelings());
      this.withOauth2(instance.getOauth2());
      this.withParams(instance.getParams());
      this.withPath(instance.getPath());
      this.withPort(instance.getPort());
      this.withProxyUrl(instance.getProxyUrl());
      this.withRelabelings(instance.getRelabelings());
      this.withScheme(instance.getScheme());
      this.withScrapeTimeout(instance.getScrapeTimeout());
      this.withTargetPort(instance.getTargetPort());
      this.withTlsConfig(instance.getTlsConfig());
      this.withAuthorization(instance.getAuthorization());
      this.withBasicAuth(instance.getBasicAuth());
      this.withBearerTokenSecret(instance.getBearerTokenSecret());
      this.withFollowRedirects(instance.getFollowRedirects());
      this.withHonorLabels(instance.getHonorLabels());
      this.withHonorTimestamps(instance.getHonorTimestamps());
      this.withInterval(instance.getInterval());
      this.withMetricRelabelings(instance.getMetricRelabelings());
      this.withOauth2(instance.getOauth2());
      this.withParams(instance.getParams());
      this.withPath(instance.getPath());
      this.withPort(instance.getPort());
      this.withProxyUrl(instance.getProxyUrl());
      this.withRelabelings(instance.getRelabelings());
      this.withScheme(instance.getScheme());
      this.withScrapeTimeout(instance.getScrapeTimeout());
      this.withTargetPort(instance.getTargetPort());
      this.withTlsConfig(instance.getTlsConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SafeAuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private SecretKeySelector bearerTokenSecret;
  private Boolean followRedirects;
  private Boolean honorLabels;
  private Boolean honorTimestamps;
  private String interval;
  private ArrayList<RelabelConfigBuilder> metricRelabelings = new ArrayList<RelabelConfigBuilder>();
  private OAuth2Builder oauth2;
  private Map<String,ArrayList<String>> params;
  private String path;
  private String port;
  private String proxyUrl;
  private ArrayList<RelabelConfigBuilder> relabelings = new ArrayList<RelabelConfigBuilder>();
  private String scheme;
  private String scrapeTimeout;
  private IntOrStringBuilder targetPort;
  private PodMetricsEndpointTLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  public SafeAuthorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(SafeAuthorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new SafeAuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} else { this.authorization = null; _visitables.get("authorization").remove(this.authorization); } return (A) this;
  }
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  public AuthorizationNested<A> withNewAuthorization() {
    return new AuthorizationNested(null);
  }
  public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
    return new AuthorizationNested(item);
  }
  public AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(null));
  }
  public AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
  }
  public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(item));
  }
  public BasicAuth buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} else { this.basicAuth = null; _visitables.get("basicAuth").remove(this.basicAuth); } return (A) this;
  }
  public boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public BasicAuthNested<A> withNewBasicAuth() {
    return new BasicAuthNested(null);
  }
  public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new BasicAuthNested(item);
  }
  public BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(null));
  }
  public BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
  }
  public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(item));
  }
  public SecretKeySelector getBearerTokenSecret() {
    return this.bearerTokenSecret;
  }
  public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret) {
    this.bearerTokenSecret=bearerTokenSecret; return (A) this;
  }
  public boolean hasBearerTokenSecret() {
    return this.bearerTokenSecret != null;
  }
  public A withNewBearerTokenSecret(String key,String name,Boolean optional) {
    return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
  }
  public Boolean getFollowRedirects() {
    return this.followRedirects;
  }
  public A withFollowRedirects(Boolean followRedirects) {
    this.followRedirects=followRedirects; return (A) this;
  }
  public boolean hasFollowRedirects() {
    return this.followRedirects != null;
  }
  public Boolean getHonorLabels() {
    return this.honorLabels;
  }
  public A withHonorLabels(Boolean honorLabels) {
    this.honorLabels=honorLabels; return (A) this;
  }
  public boolean hasHonorLabels() {
    return this.honorLabels != null;
  }
  public Boolean getHonorTimestamps() {
    return this.honorTimestamps;
  }
  public A withHonorTimestamps(Boolean honorTimestamps) {
    this.honorTimestamps=honorTimestamps; return (A) this;
  }
  public boolean hasHonorTimestamps() {
    return this.honorTimestamps != null;
  }
  public String getInterval() {
    return this.interval;
  }
  public A withInterval(String interval) {
    this.interval=interval; return (A) this;
  }
  public boolean hasInterval() {
    return this.interval != null;
  }
  public A addToMetricRelabelings(int index,RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= metricRelabelings.size()) { _visitables.get("metricRelabelings").add(builder); metricRelabelings.add(builder); } else { _visitables.get("metricRelabelings").add(index, builder); metricRelabelings.add(index, builder);}
    return (A)this;
  }
  public A setToMetricRelabelings(int index,RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= metricRelabelings.size()) { _visitables.get("metricRelabelings").add(builder); metricRelabelings.add(builder); } else { _visitables.get("metricRelabelings").set(index, builder); metricRelabelings.set(index, builder);}
    return (A)this;
  }
  public A addToMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A addAllToMetricRelabelings(Collection<RelabelConfig> items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A removeFromMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder); this.metricRelabelings.remove(builder);} return (A)this;
  }
  public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items) {
    if (this.metricRelabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder); this.metricRelabelings.remove(builder);} return (A)this;
  }
  public A removeMatchingFromMetricRelabelings(Predicate<RelabelConfigBuilder> predicate) {
    if (metricRelabelings == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = metricRelabelings.iterator();
    final List visitables = _visitables.get("metricRelabelings");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<RelabelConfig> buildMetricRelabelings() {
    return metricRelabelings != null ? build(metricRelabelings) : null;
  }
  public RelabelConfig buildMetricRelabeling(int index) {
    return this.metricRelabelings.get(index).build();
  }
  public RelabelConfig buildFirstMetricRelabeling() {
    return this.metricRelabelings.get(0).build();
  }
  public RelabelConfig buildLastMetricRelabeling() {
    return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
  }
  public RelabelConfig buildMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMetricRelabelings(List<RelabelConfig> metricRelabelings) {
    if (this.metricRelabelings != null) { _visitables.get("metricRelabelings").clear();}
    if (metricRelabelings != null) {this.metricRelabelings = new ArrayList(); for (RelabelConfig item : metricRelabelings){this.addToMetricRelabelings(item);}} else { this.metricRelabelings = null;} return (A) this;
  }
  public A withMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... metricRelabelings) {
    if (this.metricRelabelings != null) {this.metricRelabelings.clear(); _visitables.remove("metricRelabelings"); }
    if (metricRelabelings != null) {for (RelabelConfig item :metricRelabelings){ this.addToMetricRelabelings(item);}} return (A) this;
  }
  public boolean hasMetricRelabelings() {
    return metricRelabelings != null && !metricRelabelings.isEmpty();
  }
  public MetricRelabelingsNested<A> addNewMetricRelabeling() {
    return new MetricRelabelingsNested(-1, null);
  }
  public MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item) {
    return new MetricRelabelingsNested(-1, item);
  }
  public MetricRelabelingsNested<A> setNewMetricRelabelingLike(int index,RelabelConfig item) {
    return new MetricRelabelingsNested(index, item);
  }
  public MetricRelabelingsNested<A> editMetricRelabeling(int index) {
    if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public MetricRelabelingsNested<A> editFirstMetricRelabeling() {
    if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
  }
  public MetricRelabelingsNested<A> editLastMetricRelabeling() {
    int index = metricRelabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public MetricRelabelingsNested<A> editMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<metricRelabelings.size();i++) { 
    if (predicate.test(metricRelabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public OAuth2 buildOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public A withOauth2(OAuth2 oauth2) {
    _visitables.get("oauth2").remove(this.oauth2);
    if (oauth2!=null){ this.oauth2= new OAuth2Builder(oauth2); _visitables.get("oauth2").add(this.oauth2);} else { this.oauth2 = null; _visitables.get("oauth2").remove(this.oauth2); } return (A) this;
  }
  public boolean hasOauth2() {
    return this.oauth2 != null;
  }
  public Oauth2Nested<A> withNewOauth2() {
    return new Oauth2Nested(null);
  }
  public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
    return new Oauth2Nested(item);
  }
  public Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(null));
  }
  public Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(new OAuth2Builder().build()));
  }
  public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
    return withNewOauth2Like(java.util.Optional.ofNullable(buildOauth2()).orElse(item));
  }
  public A addToParams(String key,ArrayList<String> value) {
    if(this.params == null && key != null && value != null) { this.params = new LinkedHashMap(); }
    if(key != null && value != null) {this.params.put(key, value);} return (A)this;
  }
  public A addToParams(Map<String,ArrayList<String>> map) {
    if(this.params == null && map != null) { this.params = new LinkedHashMap(); }
    if(map != null) { this.params.putAll(map);} return (A)this;
  }
  public A removeFromParams(String key) {
    if(this.params == null) { return (A) this; }
    if(key != null && this.params != null) {this.params.remove(key);} return (A)this;
  }
  public A removeFromParams(Map<String,ArrayList<String>> map) {
    if(this.params == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.params != null){this.params.remove(key);}}} return (A)this;
  }
  public Map<String,ArrayList<String>> getParams() {
    return this.params;
  }
  public <K,V>A withParams(Map<String,ArrayList<String>> params) {
    if (params == null) { this.params =  null;} else {this.params = new LinkedHashMap(params);} return (A) this;
  }
  public boolean hasParams() {
    return this.params != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public boolean hasPath() {
    return this.path != null;
  }
  public String getPort() {
    return this.port;
  }
  public A withPort(String port) {
    this.port=port; return (A) this;
  }
  public boolean hasPort() {
    return this.port != null;
  }
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl=proxyUrl; return (A) this;
  }
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  public A addToRelabelings(int index,RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= relabelings.size()) { _visitables.get("relabelings").add(builder); relabelings.add(builder); } else { _visitables.get("relabelings").add(index, builder); relabelings.add(index, builder);}
    return (A)this;
  }
  public A setToRelabelings(int index,RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= relabelings.size()) { _visitables.get("relabelings").add(builder); relabelings.add(builder); } else { _visitables.get("relabelings").set(index, builder); relabelings.set(index, builder);}
    return (A)this;
  }
  public A addToRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  public A addAllToRelabelings(Collection<RelabelConfig> items) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  public A removeFromRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder); this.relabelings.remove(builder);} return (A)this;
  }
  public A removeAllFromRelabelings(Collection<RelabelConfig> items) {
    if (this.relabelings == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder); this.relabelings.remove(builder);} return (A)this;
  }
  public A removeMatchingFromRelabelings(Predicate<RelabelConfigBuilder> predicate) {
    if (relabelings == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = relabelings.iterator();
    final List visitables = _visitables.get("relabelings");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<RelabelConfig> buildRelabelings() {
    return relabelings != null ? build(relabelings) : null;
  }
  public RelabelConfig buildRelabeling(int index) {
    return this.relabelings.get(index).build();
  }
  public RelabelConfig buildFirstRelabeling() {
    return this.relabelings.get(0).build();
  }
  public RelabelConfig buildLastRelabeling() {
    return this.relabelings.get(relabelings.size() - 1).build();
  }
  public RelabelConfig buildMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelabelings(List<RelabelConfig> relabelings) {
    if (this.relabelings != null) { _visitables.get("relabelings").clear();}
    if (relabelings != null) {this.relabelings = new ArrayList(); for (RelabelConfig item : relabelings){this.addToRelabelings(item);}} else { this.relabelings = null;} return (A) this;
  }
  public A withRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelings) {
    if (this.relabelings != null) {this.relabelings.clear(); _visitables.remove("relabelings"); }
    if (relabelings != null) {for (RelabelConfig item :relabelings){ this.addToRelabelings(item);}} return (A) this;
  }
  public boolean hasRelabelings() {
    return relabelings != null && !relabelings.isEmpty();
  }
  public RelabelingsNested<A> addNewRelabeling() {
    return new RelabelingsNested(-1, null);
  }
  public RelabelingsNested<A> addNewRelabelingLike(RelabelConfig item) {
    return new RelabelingsNested(-1, item);
  }
  public RelabelingsNested<A> setNewRelabelingLike(int index,RelabelConfig item) {
    return new RelabelingsNested(index, item);
  }
  public RelabelingsNested<A> editRelabeling(int index) {
    if (relabelings.size() <= index) throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public RelabelingsNested<A> editFirstRelabeling() {
    if (relabelings.size() == 0) throw new RuntimeException("Can't edit first relabelings. The list is empty.");
    return setNewRelabelingLike(0, buildRelabeling(0));
  }
  public RelabelingsNested<A> editLastRelabeling() {
    int index = relabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relabelings. The list is empty.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public RelabelingsNested<A> editMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relabelings.size();i++) { 
    if (predicate.test(relabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relabelings. No match found.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public String getScheme() {
    return this.scheme;
  }
  public A withScheme(String scheme) {
    this.scheme=scheme; return (A) this;
  }
  public boolean hasScheme() {
    return this.scheme != null;
  }
  public String getScrapeTimeout() {
    return this.scrapeTimeout;
  }
  public A withScrapeTimeout(String scrapeTimeout) {
    this.scrapeTimeout=scrapeTimeout; return (A) this;
  }
  public boolean hasScrapeTimeout() {
    return this.scrapeTimeout != null;
  }
  public IntOrString buildTargetPort() {
    return this.targetPort!=null ?this.targetPort.build():null;
  }
  public A withTargetPort(IntOrString targetPort) {
    _visitables.get("targetPort").remove(this.targetPort);
    if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} else { this.targetPort = null; _visitables.get("targetPort").remove(this.targetPort); } return (A) this;
  }
  public boolean hasTargetPort() {
    return this.targetPort != null;
  }
  public A withNewTargetPort(Object value) {
    return (A)withTargetPort(new IntOrString(value));
  }
  public TargetPortNested<A> withNewTargetPort() {
    return new TargetPortNested(null);
  }
  public TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
    return new TargetPortNested(item);
  }
  public TargetPortNested<A> editTargetPort() {
    return withNewTargetPortLike(java.util.Optional.ofNullable(buildTargetPort()).orElse(null));
  }
  public TargetPortNested<A> editOrNewTargetPort() {
    return withNewTargetPortLike(java.util.Optional.ofNullable(buildTargetPort()).orElse(new IntOrStringBuilder().build()));
  }
  public TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
    return withNewTargetPortLike(java.util.Optional.ofNullable(buildTargetPort()).orElse(item));
  }
  public PodMetricsEndpointTLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(PodMetricsEndpointTLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new PodMetricsEndpointTLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} else { this.tlsConfig = null; _visitables.get("tlsConfig").remove(this.tlsConfig); } return (A) this;
  }
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  public TlsConfigNested<A> withNewTlsConfigLike(PodMetricsEndpointTLSConfig item) {
    return new TlsConfigNested(item);
  }
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new PodMetricsEndpointTLSConfigBuilder().build()));
  }
  public TlsConfigNested<A> editOrNewTlsConfigLike(PodMetricsEndpointTLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodMetricsEndpointFluent that = (PodMetricsEndpointFluent) o;
    if (!java.util.Objects.equals(authorization, that.authorization)) return false;

    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;

    if (!java.util.Objects.equals(bearerTokenSecret, that.bearerTokenSecret)) return false;

    if (!java.util.Objects.equals(followRedirects, that.followRedirects)) return false;

    if (!java.util.Objects.equals(honorLabels, that.honorLabels)) return false;

    if (!java.util.Objects.equals(honorTimestamps, that.honorTimestamps)) return false;

    if (!java.util.Objects.equals(interval, that.interval)) return false;

    if (!java.util.Objects.equals(metricRelabelings, that.metricRelabelings)) return false;

    if (!java.util.Objects.equals(oauth2, that.oauth2)) return false;

    if (!java.util.Objects.equals(params, that.params)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;

    if (!java.util.Objects.equals(relabelings, that.relabelings)) return false;

    if (!java.util.Objects.equals(scheme, that.scheme)) return false;

    if (!java.util.Objects.equals(scrapeTimeout, that.scrapeTimeout)) return false;

    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;

    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerTokenSecret,  followRedirects,  honorLabels,  honorTimestamps,  interval,  metricRelabelings,  oauth2,  params,  path,  port,  proxyUrl,  relabelings,  scheme,  scrapeTimeout,  targetPort,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerTokenSecret != null) { sb.append("bearerTokenSecret:"); sb.append(bearerTokenSecret + ","); }
    if (followRedirects != null) { sb.append("followRedirects:"); sb.append(followRedirects + ","); }
    if (honorLabels != null) { sb.append("honorLabels:"); sb.append(honorLabels + ","); }
    if (honorTimestamps != null) { sb.append("honorTimestamps:"); sb.append(honorTimestamps + ","); }
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    if (metricRelabelings != null && !metricRelabelings.isEmpty()) { sb.append("metricRelabelings:"); sb.append(metricRelabelings + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (params != null && !params.isEmpty()) { sb.append("params:"); sb.append(params + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (relabelings != null && !relabelings.isEmpty()) { sb.append("relabelings:"); sb.append(relabelings + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (scrapeTimeout != null) { sb.append("scrapeTimeout:"); sb.append(scrapeTimeout + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withFollowRedirects() {
    return withFollowRedirects(true);
  }
  public A withHonorLabels() {
    return withHonorLabels(true);
  }
  public A withHonorTimestamps() {
    return withHonorTimestamps(true);
  }
  public class AuthorizationNested<N> extends SafeAuthorizationFluent<AuthorizationNested<N>> implements Nested<N>{
    AuthorizationNested(SafeAuthorization item) {
      this.builder = new SafeAuthorizationBuilder(this, item);
    }
    SafeAuthorizationBuilder builder;
    public N and() {
      return (N) PodMetricsEndpointFluent.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  public class BasicAuthNested<N> extends BasicAuthFluent<BasicAuthNested<N>> implements Nested<N>{
    BasicAuthNested(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthBuilder builder;
    public N and() {
      return (N) PodMetricsEndpointFluent.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  public class MetricRelabelingsNested<N> extends RelabelConfigFluent<MetricRelabelingsNested<N>> implements Nested<N>{
    MetricRelabelingsNested(int index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelConfigBuilder builder;
    int index;
    public N and() {
      return (N) PodMetricsEndpointFluent.this.setToMetricRelabelings(index,builder.build());
    }
    public N endMetricRelabeling() {
      return and();
    }
    
  }
  public class Oauth2Nested<N> extends OAuth2Fluent<Oauth2Nested<N>> implements Nested<N>{
    Oauth2Nested(OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    OAuth2Builder builder;
    public N and() {
      return (N) PodMetricsEndpointFluent.this.withOauth2(builder.build());
    }
    public N endOauth2() {
      return and();
    }
    
  }
  public class RelabelingsNested<N> extends RelabelConfigFluent<RelabelingsNested<N>> implements Nested<N>{
    RelabelingsNested(int index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelConfigBuilder builder;
    int index;
    public N and() {
      return (N) PodMetricsEndpointFluent.this.setToRelabelings(index,builder.build());
    }
    public N endRelabeling() {
      return and();
    }
    
  }
  public class TargetPortNested<N> extends IntOrStringFluent<TargetPortNested<N>> implements Nested<N>{
    TargetPortNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) PodMetricsEndpointFluent.this.withTargetPort(builder.build());
    }
    public N endTargetPort() {
      return and();
    }
    
  }
  public class TlsConfigNested<N> extends PodMetricsEndpointTLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(PodMetricsEndpointTLSConfig item) {
      this.builder = new PodMetricsEndpointTLSConfigBuilder(this, item);
    }
    PodMetricsEndpointTLSConfigBuilder builder;
    public N and() {
      return (N) PodMetricsEndpointFluent.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}