package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectReferenceBuilder extends ObjectReferenceFluent<ObjectReferenceBuilder> implements VisitableBuilder<ObjectReference,ObjectReferenceBuilder>{
  public ObjectReferenceBuilder() {
    this(false);
  }
  public ObjectReferenceBuilder(Boolean validationEnabled) {
    this(new ObjectReference(), validationEnabled);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObjectReference(), validationEnabled);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,ObjectReference instance) {
    this(fluent, instance, false);
  }
  public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent,ObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ObjectReference());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResource(instance.getResource());
      fluent.withGroup(instance.getGroup());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResource(instance.getResource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ObjectReferenceBuilder(ObjectReference instance) {
    this(instance,false);
  }
  public ObjectReferenceBuilder(ObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ObjectReference());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResource(instance.getResource());
      this.withGroup(instance.getGroup());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResource(instance.getResource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ObjectReference build() {
    ObjectReference buildable = new ObjectReference(fluent.getGroup(),fluent.getName(),fluent.getNamespace(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}