package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OAuth2Fluent<A extends OAuth2Fluent<A>> extends BaseFluent<A>{
  public OAuth2Fluent() {
  }
  public OAuth2Fluent(OAuth2 instance) {
    instance = (instance != null ? instance : new OAuth2());

    if (instance != null) {
      this.withClientId(instance.getClientId());
      this.withClientSecret(instance.getClientSecret());
      this.withEndpointParams(instance.getEndpointParams());
      this.withScopes(instance.getScopes());
      this.withTokenUrl(instance.getTokenUrl());
      this.withClientId(instance.getClientId());
      this.withClientSecret(instance.getClientSecret());
      this.withEndpointParams(instance.getEndpointParams());
      this.withScopes(instance.getScopes());
      this.withTokenUrl(instance.getTokenUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SecretOrConfigMapBuilder clientId;
  private SecretKeySelector clientSecret;
  private Map<String,String> endpointParams;
  private List<String> scopes = new ArrayList<String>();
  private String tokenUrl;
  private Map<String,Object> additionalProperties;
  public SecretOrConfigMap buildClientId() {
    return this.clientId!=null ?this.clientId.build():null;
  }
  public A withClientId(SecretOrConfigMap clientId) {
    _visitables.get("clientId").remove(this.clientId);
    if (clientId!=null){ this.clientId= new SecretOrConfigMapBuilder(clientId); _visitables.get("clientId").add(this.clientId);} else { this.clientId = null; _visitables.get("clientId").remove(this.clientId); } return (A) this;
  }
  public boolean hasClientId() {
    return this.clientId != null;
  }
  public ClientIdNested<A> withNewClientId() {
    return new ClientIdNested(null);
  }
  public ClientIdNested<A> withNewClientIdLike(SecretOrConfigMap item) {
    return new ClientIdNested(item);
  }
  public ClientIdNested<A> editClientId() {
    return withNewClientIdLike(java.util.Optional.ofNullable(buildClientId()).orElse(null));
  }
  public ClientIdNested<A> editOrNewClientId() {
    return withNewClientIdLike(java.util.Optional.ofNullable(buildClientId()).orElse(new SecretOrConfigMapBuilder().build()));
  }
  public ClientIdNested<A> editOrNewClientIdLike(SecretOrConfigMap item) {
    return withNewClientIdLike(java.util.Optional.ofNullable(buildClientId()).orElse(item));
  }
  public SecretKeySelector getClientSecret() {
    return this.clientSecret;
  }
  public A withClientSecret(SecretKeySelector clientSecret) {
    this.clientSecret=clientSecret; return (A) this;
  }
  public boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  public A withNewClientSecret(String key,String name,Boolean optional) {
    return (A)withClientSecret(new SecretKeySelector(key, name, optional));
  }
  public A addToEndpointParams(String key,String value) {
    if(this.endpointParams == null && key != null && value != null) { this.endpointParams = new LinkedHashMap(); }
    if(key != null && value != null) {this.endpointParams.put(key, value);} return (A)this;
  }
  public A addToEndpointParams(Map<String,String> map) {
    if(this.endpointParams == null && map != null) { this.endpointParams = new LinkedHashMap(); }
    if(map != null) { this.endpointParams.putAll(map);} return (A)this;
  }
  public A removeFromEndpointParams(String key) {
    if(this.endpointParams == null) { return (A) this; }
    if(key != null && this.endpointParams != null) {this.endpointParams.remove(key);} return (A)this;
  }
  public A removeFromEndpointParams(Map<String,String> map) {
    if(this.endpointParams == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.endpointParams != null){this.endpointParams.remove(key);}}} return (A)this;
  }
  public Map<String,String> getEndpointParams() {
    return this.endpointParams;
  }
  public <K,V>A withEndpointParams(Map<String,String> endpointParams) {
    if (endpointParams == null) { this.endpointParams =  null;} else {this.endpointParams = new LinkedHashMap(endpointParams);} return (A) this;
  }
  public boolean hasEndpointParams() {
    return this.endpointParams != null;
  }
  public A addToScopes(int index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.add(index, item);
    return (A)this;
  }
  public A setToScopes(int index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.set(index, item); return (A)this;
  }
  public A addToScopes(java.lang.String... items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A addAllToScopes(Collection<String> items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A removeFromScopes(java.lang.String... items) {
    if (this.scopes == null) return (A)this;
    for (String item : items) { this.scopes.remove(item);} return (A)this;
  }
  public A removeAllFromScopes(Collection<String> items) {
    if (this.scopes == null) return (A)this;
    for (String item : items) { this.scopes.remove(item);} return (A)this;
  }
  public List<String> getScopes() {
    return this.scopes;
  }
  public String getScope(int index) {
    return this.scopes.get(index);
  }
  public String getFirstScope() {
    return this.scopes.get(0);
  }
  public String getLastScope() {
    return this.scopes.get(scopes.size() - 1);
  }
  public String getMatchingScope(Predicate<String> predicate) {
    for (String item: scopes) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingScope(Predicate<String> predicate) {
    for (String item: scopes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withScopes(List<String> scopes) {
    if (scopes != null) {this.scopes = new ArrayList(); for (String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
  }
  public A withScopes(java.lang.String... scopes) {
    if (this.scopes != null) {this.scopes.clear(); _visitables.remove("scopes"); }
    if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
  }
  public boolean hasScopes() {
    return scopes != null && !scopes.isEmpty();
  }
  public String getTokenUrl() {
    return this.tokenUrl;
  }
  public A withTokenUrl(String tokenUrl) {
    this.tokenUrl=tokenUrl; return (A) this;
  }
  public boolean hasTokenUrl() {
    return this.tokenUrl != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OAuth2Fluent that = (OAuth2Fluent) o;
    if (!java.util.Objects.equals(clientId, that.clientId)) return false;

    if (!java.util.Objects.equals(clientSecret, that.clientSecret)) return false;

    if (!java.util.Objects.equals(endpointParams, that.endpointParams)) return false;

    if (!java.util.Objects.equals(scopes, that.scopes)) return false;

    if (!java.util.Objects.equals(tokenUrl, that.tokenUrl)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientId,  clientSecret,  endpointParams,  scopes,  tokenUrl,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientId != null) { sb.append("clientId:"); sb.append(clientId + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (endpointParams != null && !endpointParams.isEmpty()) { sb.append("endpointParams:"); sb.append(endpointParams + ","); }
    if (scopes != null && !scopes.isEmpty()) { sb.append("scopes:"); sb.append(scopes + ","); }
    if (tokenUrl != null) { sb.append("tokenUrl:"); sb.append(tokenUrl + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClientIdNested<N> extends SecretOrConfigMapFluent<ClientIdNested<N>> implements Nested<N>{
    ClientIdNested(SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) OAuth2Fluent.this.withClientId(builder.build());
    }
    public N endClientId() {
      return and();
    }
    
  }
  
}