package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuth2Builder extends OAuth2Fluent<OAuth2Builder> implements VisitableBuilder<OAuth2,OAuth2Builder>{
  public OAuth2Builder() {
    this(false);
  }
  public OAuth2Builder(Boolean validationEnabled) {
    this(new OAuth2(), validationEnabled);
  }
  public OAuth2Builder(OAuth2Fluent<?> fluent) {
    this(fluent, false);
  }
  public OAuth2Builder(OAuth2Fluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuth2(), validationEnabled);
  }
  public OAuth2Builder(OAuth2Fluent<?> fluent,OAuth2 instance) {
    this(fluent, instance, false);
  }
  public OAuth2Builder(OAuth2Fluent<?> fluent,OAuth2 instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OAuth2());

    if (instance != null) {
      fluent.withClientId(instance.getClientId());
      fluent.withClientSecret(instance.getClientSecret());
      fluent.withEndpointParams(instance.getEndpointParams());
      fluent.withScopes(instance.getScopes());
      fluent.withTokenUrl(instance.getTokenUrl());
      fluent.withClientId(instance.getClientId());
      fluent.withClientSecret(instance.getClientSecret());
      fluent.withEndpointParams(instance.getEndpointParams());
      fluent.withScopes(instance.getScopes());
      fluent.withTokenUrl(instance.getTokenUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OAuth2Builder(OAuth2 instance) {
    this(instance,false);
  }
  public OAuth2Builder(OAuth2 instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OAuth2());

    if (instance != null) {
      this.withClientId(instance.getClientId());
      this.withClientSecret(instance.getClientSecret());
      this.withEndpointParams(instance.getEndpointParams());
      this.withScopes(instance.getScopes());
      this.withTokenUrl(instance.getTokenUrl());
      this.withClientId(instance.getClientId());
      this.withClientSecret(instance.getClientSecret());
      this.withEndpointParams(instance.getEndpointParams());
      this.withScopes(instance.getScopes());
      this.withTokenUrl(instance.getTokenUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OAuth2Fluent<?> fluent;
  Boolean validationEnabled;
  public OAuth2 build() {
    OAuth2 buildable = new OAuth2(fluent.buildClientId(),fluent.getClientSecret(),fluent.getEndpointParams(),fluent.getScopes(),fluent.getTokenUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}