package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AuthorizationFluent<A extends AuthorizationFluent<A>> extends BaseFluent<A>{
  public AuthorizationFluent() {
  }
  public AuthorizationFluent(Authorization instance) {
    instance = (instance != null ? instance : new Authorization());

    if (instance != null) {
      this.withCredentials(instance.getCredentials());
      this.withCredentialsFile(instance.getCredentialsFile());
      this.withType(instance.getType());
      this.withCredentials(instance.getCredentials());
      this.withCredentialsFile(instance.getCredentialsFile());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SecretKeySelector credentials;
  private String credentialsFile;
  private String type;
  private Map<String,Object> additionalProperties;
  public SecretKeySelector getCredentials() {
    return this.credentials;
  }
  public A withCredentials(SecretKeySelector credentials) {
    this.credentials=credentials; return (A) this;
  }
  public boolean hasCredentials() {
    return this.credentials != null;
  }
  public A withNewCredentials(String key,String name,Boolean optional) {
    return (A)withCredentials(new SecretKeySelector(key, name, optional));
  }
  public String getCredentialsFile() {
    return this.credentialsFile;
  }
  public A withCredentialsFile(String credentialsFile) {
    this.credentialsFile=credentialsFile; return (A) this;
  }
  public boolean hasCredentialsFile() {
    return this.credentialsFile != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthorizationFluent that = (AuthorizationFluent) o;
    if (!java.util.Objects.equals(credentials, that.credentials)) return false;

    if (!java.util.Objects.equals(credentialsFile, that.credentialsFile)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(credentials,  credentialsFile,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (credentials != null) { sb.append("credentials:"); sb.append(credentials + ","); }
    if (credentialsFile != null) { sb.append("credentialsFile:"); sb.append(credentialsFile + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}