package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AttachMetadataBuilder extends AttachMetadataFluent<AttachMetadataBuilder> implements VisitableBuilder<AttachMetadata,AttachMetadataBuilder>{
  public AttachMetadataBuilder() {
    this(false);
  }
  public AttachMetadataBuilder(Boolean validationEnabled) {
    this(new AttachMetadata(), validationEnabled);
  }
  public AttachMetadataBuilder(AttachMetadataFluent<?> fluent) {
    this(fluent, false);
  }
  public AttachMetadataBuilder(AttachMetadataFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AttachMetadata(), validationEnabled);
  }
  public AttachMetadataBuilder(AttachMetadataFluent<?> fluent,AttachMetadata instance) {
    this(fluent, instance, false);
  }
  public AttachMetadataBuilder(AttachMetadataFluent<?> fluent,AttachMetadata instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AttachMetadata());

    if (instance != null) {
      fluent.withNode(instance.getNode());
      fluent.withNode(instance.getNode());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AttachMetadataBuilder(AttachMetadata instance) {
    this(instance,false);
  }
  public AttachMetadataBuilder(AttachMetadata instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AttachMetadata());

    if (instance != null) {
      this.withNode(instance.getNode());
      this.withNode(instance.getNode());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AttachMetadataFluent<?> fluent;
  Boolean validationEnabled;
  public AttachMetadata build() {
    AttachMetadata buildable = new AttachMetadata(fluent.getNode());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}