package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlertmanagerSpecBuilder extends AlertmanagerSpecFluent<AlertmanagerSpecBuilder> implements VisitableBuilder<AlertmanagerSpec,AlertmanagerSpecBuilder>{
  public AlertmanagerSpecBuilder() {
    this(false);
  }
  public AlertmanagerSpecBuilder(Boolean validationEnabled) {
    this(new AlertmanagerSpec(), validationEnabled);
  }
  public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AlertmanagerSpec(), validationEnabled);
  }
  public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent,AlertmanagerSpec instance) {
    this(fluent, instance, false);
  }
  public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent,AlertmanagerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AlertmanagerSpec());

    if (instance != null) {
      fluent.withAdditionalPeers(instance.getAdditionalPeers());
      fluent.withAffinity(instance.getAffinity());
      fluent.withAlertmanagerConfigNamespaceSelector(instance.getAlertmanagerConfigNamespaceSelector());
      fluent.withAlertmanagerConfigSelector(instance.getAlertmanagerConfigSelector());
      fluent.withAlertmanagerConfiguration(instance.getAlertmanagerConfiguration());
      fluent.withBaseImage(instance.getBaseImage());
      fluent.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress());
      fluent.withClusterGossipInterval(instance.getClusterGossipInterval());
      fluent.withClusterPeerTimeout(instance.getClusterPeerTimeout());
      fluent.withClusterPushpullInterval(instance.getClusterPushpullInterval());
      fluent.withConfigMaps(instance.getConfigMaps());
      fluent.withConfigSecret(instance.getConfigSecret());
      fluent.withContainers(instance.getContainers());
      fluent.withExternalUrl(instance.getExternalUrl());
      fluent.withForceEnableClusterMode(instance.getForceEnableClusterMode());
      fluent.withHostAliases(instance.getHostAliases());
      fluent.withImage(instance.getImage());
      fluent.withImagePullSecrets(instance.getImagePullSecrets());
      fluent.withInitContainers(instance.getInitContainers());
      fluent.withListenLocal(instance.getListenLocal());
      fluent.withLogFormat(instance.getLogFormat());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withMinReadySeconds(instance.getMinReadySeconds());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withPaused(instance.getPaused());
      fluent.withPodMetadata(instance.getPodMetadata());
      fluent.withPortName(instance.getPortName());
      fluent.withPriorityClassName(instance.getPriorityClassName());
      fluent.withReplicas(instance.getReplicas());
      fluent.withResources(instance.getResources());
      fluent.withRetention(instance.getRetention());
      fluent.withRoutePrefix(instance.getRoutePrefix());
      fluent.withSecrets(instance.getSecrets());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withSha(instance.getSha());
      fluent.withStorage(instance.getStorage());
      fluent.withTag(instance.getTag());
      fluent.withTolerations(instance.getTolerations());
      fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      fluent.withVersion(instance.getVersion());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withVolumes(instance.getVolumes());
      fluent.withAdditionalPeers(instance.getAdditionalPeers());
      fluent.withAffinity(instance.getAffinity());
      fluent.withAlertmanagerConfigNamespaceSelector(instance.getAlertmanagerConfigNamespaceSelector());
      fluent.withAlertmanagerConfigSelector(instance.getAlertmanagerConfigSelector());
      fluent.withAlertmanagerConfiguration(instance.getAlertmanagerConfiguration());
      fluent.withBaseImage(instance.getBaseImage());
      fluent.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress());
      fluent.withClusterGossipInterval(instance.getClusterGossipInterval());
      fluent.withClusterPeerTimeout(instance.getClusterPeerTimeout());
      fluent.withClusterPushpullInterval(instance.getClusterPushpullInterval());
      fluent.withConfigMaps(instance.getConfigMaps());
      fluent.withConfigSecret(instance.getConfigSecret());
      fluent.withContainers(instance.getContainers());
      fluent.withExternalUrl(instance.getExternalUrl());
      fluent.withForceEnableClusterMode(instance.getForceEnableClusterMode());
      fluent.withHostAliases(instance.getHostAliases());
      fluent.withImage(instance.getImage());
      fluent.withImagePullSecrets(instance.getImagePullSecrets());
      fluent.withInitContainers(instance.getInitContainers());
      fluent.withListenLocal(instance.getListenLocal());
      fluent.withLogFormat(instance.getLogFormat());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withMinReadySeconds(instance.getMinReadySeconds());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withPaused(instance.getPaused());
      fluent.withPodMetadata(instance.getPodMetadata());
      fluent.withPortName(instance.getPortName());
      fluent.withPriorityClassName(instance.getPriorityClassName());
      fluent.withReplicas(instance.getReplicas());
      fluent.withResources(instance.getResources());
      fluent.withRetention(instance.getRetention());
      fluent.withRoutePrefix(instance.getRoutePrefix());
      fluent.withSecrets(instance.getSecrets());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withSha(instance.getSha());
      fluent.withStorage(instance.getStorage());
      fluent.withTag(instance.getTag());
      fluent.withTolerations(instance.getTolerations());
      fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      fluent.withVersion(instance.getVersion());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withVolumes(instance.getVolumes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AlertmanagerSpecBuilder(AlertmanagerSpec instance) {
    this(instance,false);
  }
  public AlertmanagerSpecBuilder(AlertmanagerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AlertmanagerSpec());

    if (instance != null) {
      this.withAdditionalPeers(instance.getAdditionalPeers());
      this.withAffinity(instance.getAffinity());
      this.withAlertmanagerConfigNamespaceSelector(instance.getAlertmanagerConfigNamespaceSelector());
      this.withAlertmanagerConfigSelector(instance.getAlertmanagerConfigSelector());
      this.withAlertmanagerConfiguration(instance.getAlertmanagerConfiguration());
      this.withBaseImage(instance.getBaseImage());
      this.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress());
      this.withClusterGossipInterval(instance.getClusterGossipInterval());
      this.withClusterPeerTimeout(instance.getClusterPeerTimeout());
      this.withClusterPushpullInterval(instance.getClusterPushpullInterval());
      this.withConfigMaps(instance.getConfigMaps());
      this.withConfigSecret(instance.getConfigSecret());
      this.withContainers(instance.getContainers());
      this.withExternalUrl(instance.getExternalUrl());
      this.withForceEnableClusterMode(instance.getForceEnableClusterMode());
      this.withHostAliases(instance.getHostAliases());
      this.withImage(instance.getImage());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withInitContainers(instance.getInitContainers());
      this.withListenLocal(instance.getListenLocal());
      this.withLogFormat(instance.getLogFormat());
      this.withLogLevel(instance.getLogLevel());
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withNodeSelector(instance.getNodeSelector());
      this.withPaused(instance.getPaused());
      this.withPodMetadata(instance.getPodMetadata());
      this.withPortName(instance.getPortName());
      this.withPriorityClassName(instance.getPriorityClassName());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
      this.withRetention(instance.getRetention());
      this.withRoutePrefix(instance.getRoutePrefix());
      this.withSecrets(instance.getSecrets());
      this.withSecurityContext(instance.getSecurityContext());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSha(instance.getSha());
      this.withStorage(instance.getStorage());
      this.withTag(instance.getTag());
      this.withTolerations(instance.getTolerations());
      this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      this.withVersion(instance.getVersion());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withVolumes(instance.getVolumes());
      this.withAdditionalPeers(instance.getAdditionalPeers());
      this.withAffinity(instance.getAffinity());
      this.withAlertmanagerConfigNamespaceSelector(instance.getAlertmanagerConfigNamespaceSelector());
      this.withAlertmanagerConfigSelector(instance.getAlertmanagerConfigSelector());
      this.withAlertmanagerConfiguration(instance.getAlertmanagerConfiguration());
      this.withBaseImage(instance.getBaseImage());
      this.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress());
      this.withClusterGossipInterval(instance.getClusterGossipInterval());
      this.withClusterPeerTimeout(instance.getClusterPeerTimeout());
      this.withClusterPushpullInterval(instance.getClusterPushpullInterval());
      this.withConfigMaps(instance.getConfigMaps());
      this.withConfigSecret(instance.getConfigSecret());
      this.withContainers(instance.getContainers());
      this.withExternalUrl(instance.getExternalUrl());
      this.withForceEnableClusterMode(instance.getForceEnableClusterMode());
      this.withHostAliases(instance.getHostAliases());
      this.withImage(instance.getImage());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withInitContainers(instance.getInitContainers());
      this.withListenLocal(instance.getListenLocal());
      this.withLogFormat(instance.getLogFormat());
      this.withLogLevel(instance.getLogLevel());
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withNodeSelector(instance.getNodeSelector());
      this.withPaused(instance.getPaused());
      this.withPodMetadata(instance.getPodMetadata());
      this.withPortName(instance.getPortName());
      this.withPriorityClassName(instance.getPriorityClassName());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
      this.withRetention(instance.getRetention());
      this.withRoutePrefix(instance.getRoutePrefix());
      this.withSecrets(instance.getSecrets());
      this.withSecurityContext(instance.getSecurityContext());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSha(instance.getSha());
      this.withStorage(instance.getStorage());
      this.withTag(instance.getTag());
      this.withTolerations(instance.getTolerations());
      this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      this.withVersion(instance.getVersion());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withVolumes(instance.getVolumes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AlertmanagerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AlertmanagerSpec build() {
    AlertmanagerSpec buildable = new AlertmanagerSpec(fluent.getAdditionalPeers(),fluent.getAffinity(),fluent.buildAlertmanagerConfigNamespaceSelector(),fluent.buildAlertmanagerConfigSelector(),fluent.buildAlertmanagerConfiguration(),fluent.getBaseImage(),fluent.getClusterAdvertiseAddress(),fluent.getClusterGossipInterval(),fluent.getClusterPeerTimeout(),fluent.getClusterPushpullInterval(),fluent.getConfigMaps(),fluent.getConfigSecret(),fluent.buildContainers(),fluent.getExternalUrl(),fluent.getForceEnableClusterMode(),fluent.buildHostAliases(),fluent.getImage(),fluent.buildImagePullSecrets(),fluent.buildInitContainers(),fluent.getListenLocal(),fluent.getLogFormat(),fluent.getLogLevel(),fluent.getMinReadySeconds(),fluent.getNodeSelector(),fluent.getPaused(),fluent.buildPodMetadata(),fluent.getPortName(),fluent.getPriorityClassName(),fluent.getReplicas(),fluent.buildResources(),fluent.getRetention(),fluent.getRoutePrefix(),fluent.getSecrets(),fluent.getSecurityContext(),fluent.getServiceAccountName(),fluent.getSha(),fluent.buildStorage(),fluent.getTag(),fluent.getTolerations(),fluent.getTopologySpreadConstraints(),fluent.getVersion(),fluent.getVolumeMounts(),fluent.getVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}