package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlertmanagerConfigurationBuilder extends AlertmanagerConfigurationFluent<AlertmanagerConfigurationBuilder> implements VisitableBuilder<AlertmanagerConfiguration,AlertmanagerConfigurationBuilder>{
  public AlertmanagerConfigurationBuilder() {
    this(false);
  }
  public AlertmanagerConfigurationBuilder(Boolean validationEnabled) {
    this(new AlertmanagerConfiguration(), validationEnabled);
  }
  public AlertmanagerConfigurationBuilder(AlertmanagerConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public AlertmanagerConfigurationBuilder(AlertmanagerConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AlertmanagerConfiguration(), validationEnabled);
  }
  public AlertmanagerConfigurationBuilder(AlertmanagerConfigurationFluent<?> fluent,AlertmanagerConfiguration instance) {
    this(fluent, instance, false);
  }
  public AlertmanagerConfigurationBuilder(AlertmanagerConfigurationFluent<?> fluent,AlertmanagerConfiguration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AlertmanagerConfiguration());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AlertmanagerConfigurationBuilder(AlertmanagerConfiguration instance) {
    this(instance,false);
  }
  public AlertmanagerConfigurationBuilder(AlertmanagerConfiguration instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AlertmanagerConfiguration());

    if (instance != null) {
      this.withName(instance.getName());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AlertmanagerConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public AlertmanagerConfiguration build() {
    AlertmanagerConfiguration buildable = new AlertmanagerConfiguration(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}