package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlertingSpecBuilder extends AlertingSpecFluent<AlertingSpecBuilder> implements VisitableBuilder<AlertingSpec,AlertingSpecBuilder>{
  public AlertingSpecBuilder() {
    this(false);
  }
  public AlertingSpecBuilder(Boolean validationEnabled) {
    this(new AlertingSpec(), validationEnabled);
  }
  public AlertingSpecBuilder(AlertingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AlertingSpecBuilder(AlertingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AlertingSpec(), validationEnabled);
  }
  public AlertingSpecBuilder(AlertingSpecFluent<?> fluent,AlertingSpec instance) {
    this(fluent, instance, false);
  }
  public AlertingSpecBuilder(AlertingSpecFluent<?> fluent,AlertingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AlertingSpec());

    if (instance != null) {
      fluent.withAlertmanagers(instance.getAlertmanagers());
      fluent.withAlertmanagers(instance.getAlertmanagers());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AlertingSpecBuilder(AlertingSpec instance) {
    this(instance,false);
  }
  public AlertingSpecBuilder(AlertingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AlertingSpec());

    if (instance != null) {
      this.withAlertmanagers(instance.getAlertmanagers());
      this.withAlertmanagers(instance.getAlertmanagers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AlertingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AlertingSpec build() {
    AlertingSpec buildable = new AlertingSpec(fluent.buildAlertmanagers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}